/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;

public class ServerVoiceEvents {
    private final Map<UUID, Integer> clientCompatibilities = new ConcurrentHashMap<UUID, Integer>();
    private Server server;

    public ServerVoiceEvents() {
        CommonCompatibilityManager.INSTANCE.onServerStarting(this::serverStarting);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedIn(this::playerLoggedIn);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedOut(this::playerLoggedOut);
        CommonCompatibilityManager.INSTANCE.onServerStopping(this::serverStopping);
        CommonCompatibilityManager.INSTANCE.getNetManager().requestSecretChannel.setServerListener((server, player, handler, packet) -> {
            Voicechat.LOGGER.info("Received secret request of {} ({})", (Object)player.m_5446_().getString(), (Object)packet.getCompatibilityVersion());
            this.clientCompatibilities.put(player.m_142081_(), packet.getCompatibilityVersion());
            if (packet.getCompatibilityVersion() != Voicechat.COMPATIBILITY_VERSION) {
                Voicechat.LOGGER.warn("Connected client {} has incompatible voice chat version (server={}, client={})", (Object)player.m_7755_().getString(), (Object)Voicechat.COMPATIBILITY_VERSION, (Object)packet.getCompatibilityVersion());
                player.m_6352_(this.getIncompatibleMessage(packet.getCompatibilityVersion()), Util.f_137441_);
            } else {
                this.initializePlayerConnection(player);
            }
        });
    }

    public Component getIncompatibleMessage(int clientCompatibilityVersion) {
        if (clientCompatibilityVersion <= 6) {
            return new TextComponent("Your voice chat version is not compatible with the servers version.\nPlease install version ").m_7220_((Component)new TextComponent(CommonCompatibilityManager.INSTANCE.getModVersion()).m_130940_(ChatFormatting.BOLD)).m_130946_(" of ").m_7220_((Component)new TextComponent(CommonCompatibilityManager.INSTANCE.getModName()).m_130940_(ChatFormatting.BOLD)).m_130946_(".");
        }
        return new TranslatableComponent("message.voicechat.incompatible_version", new Object[]{new TextComponent(CommonCompatibilityManager.INSTANCE.getModVersion()).m_130940_(ChatFormatting.BOLD), new TextComponent(CommonCompatibilityManager.INSTANCE.getModName()).m_130940_(ChatFormatting.BOLD)});
    }

    public boolean isCompatible(ServerPlayer player) {
        return this.clientCompatibilities.getOrDefault(player.m_142081_(), -1) == Voicechat.COMPATIBILITY_VERSION;
    }

    public void serverStarting(MinecraftServer mcServer) {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
        if (!(mcServer instanceof DedicatedServer) && VoicechatClient.CLIENT_CONFIG != null && !VoicechatClient.CLIENT_CONFIG.runLocalServer.get().booleanValue()) {
            Voicechat.LOGGER.info("Disabling voice chat in singleplayer");
            return;
        }
        if (mcServer instanceof DedicatedServer && !mcServer.m_129797_()) {
            Voicechat.LOGGER.warn("Running in offline mode - Voice chat encryption is not secure!");
        }
        try {
            this.server = new Server(mcServer);
            this.server.start();
            PluginManager.instance().onServerStarted();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializePlayerConnection(ServerPlayer player) {
        if (this.server == null) {
            return;
        }
        CommonCompatibilityManager.INSTANCE.emitPlayerCompatibilityCheckSucceeded(player);
        UUID secret = this.server.getSecret(player.m_142081_());
        NetManager.sendToClient(player, new SecretPacket(player, secret, this.server.getPort(), Voicechat.SERVER_CONFIG));
        Voicechat.LOGGER.info("Sent secret to {}", (Object)player.m_5446_().getString());
    }

    public void playerLoggedIn(final ServerPlayer serverPlayer) {
        if (!Voicechat.SERVER_CONFIG.forceVoiceChat.get().booleanValue()) {
            return;
        }
        final Timer timer = new Timer("%s-login-timer".formatted(serverPlayer.m_36316_().getName()), true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                timer.cancel();
                timer.purge();
                if (!serverPlayer.f_8924_.m_130010_()) {
                    return;
                }
                if (!serverPlayer.f_8906_.f_9742_.m_129536_()) {
                    return;
                }
                if (!ServerVoiceEvents.this.isCompatible(serverPlayer)) {
                    serverPlayer.f_8924_.execute(() -> serverPlayer2.f_8906_.m_9942_((Component)new TextComponent("You need %s %s to play on this server".formatted(CommonCompatibilityManager.INSTANCE.getModName(), CommonCompatibilityManager.INSTANCE.getModVersion()))));
                }
            }
        }, Voicechat.SERVER_CONFIG.loginTimeout.get().intValue());
    }

    public void playerLoggedOut(ServerPlayer player) {
        this.clientCompatibilities.remove(player.m_142081_());
        if (this.server == null) {
            return;
        }
        this.server.disconnectClient(player.m_142081_());
        Voicechat.LOGGER.info("Disconnecting client " + player.m_5446_().getString());
    }

    @Nullable
    public Server getServer() {
        return this.server;
    }

    public void serverStopping(MinecraftServer mcServer) {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }
}

