/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.mixin;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.config.GeneralOptions;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.MiscLeftModule;
import me.cominixo.betterf3.modules.MiscRightModule;
import me.cominixo.betterf3.utils.PositionEnum;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FrameTimer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugScreenOverlay.class})
public abstract class DebugMixin {
    @Shadow
    @Final
    private Minecraft f_94030_;
    @Shadow
    @Final
    private Font f_94031_;

    @Shadow
    protected abstract List<String> m_94075_();

    @Shadow
    protected abstract List<String> m_94078_();

    @Shadow
    protected abstract void m_94058_(PoseStack var1, FrameTimer var2, int var3, int var4, boolean var5);

    public List<Component> newLeftText() {
        ArrayList<Component> list = new ArrayList<Component>();
        for (BaseModule module : BaseModule.modules) {
            if (!module.enabled) continue;
            if (module instanceof MiscLeftModule) {
                ((MiscLeftModule)module).update(this.m_94075_());
            } else {
                module.update(this.f_94030_);
            }
            list.addAll(module.linesFormatted(this.f_94030_.m_91299_()));
            if (!GeneralOptions.spaceEveryModule) continue;
            list.add((Component)new TextComponent(""));
        }
        return list;
    }

    public List<Component> newRightText() {
        ArrayList<Component> list = new ArrayList<Component>();
        for (BaseModule module : BaseModule.modulesRight) {
            if (!module.enabled) continue;
            if (module instanceof MiscRightModule) {
                ((MiscRightModule)module).update(this.m_94078_());
            } else {
                module.update(this.f_94030_);
            }
            list.addAll(module.linesFormatted(this.f_94030_.m_91299_()));
            if (!GeneralOptions.spaceEveryModule) continue;
            list.add((Component)new TextComponent(""));
        }
        return list;
    }

    @Inject(method={"renderRightText"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderRightText(PoseStack matrixStack, CallbackInfo ci) {
        if (GeneralOptions.disableMod) {
            return;
        }
        List<Component> list = this.newRightText();
        MultiBufferSource.BufferSource immediate = this.immediate(PositionEnum.RIGHT, list, matrixStack);
        for (int i = 0; i < list.size(); ++i) {
            if (Strings.isNullOrEmpty((String)list.get(i).getString())) continue;
            int height = 9;
            int width = this.f_94031_.m_92895_(list.get(i).getString());
            int windowWidth = (int)((double)this.f_94030_.m_91268_().m_85445_() / GeneralOptions.fontScale) - 2 - width;
            if (GeneralOptions.enableAnimations) {
                windowWidth += Utils.xPos;
            }
            int y = 2 + 9 * i;
            this.f_94031_.m_92841_(list.get(i), (float)windowWidth, (float)y, 0xE0E0E0, GeneralOptions.shadowText, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)immediate, false, 0, 0xF000F0);
        }
        immediate.m_109911_();
        ci.cancel();
    }

    public MultiBufferSource.BufferSource immediate(PositionEnum pos, List<Component> list, PoseStack matrixStack) {
        float f = (float)(GeneralOptions.backgroundColor >> 24 & 0xFF) / 255.0f;
        float g = (float)(GeneralOptions.backgroundColor >> 16 & 0xFF) / 255.0f;
        float h = (float)(GeneralOptions.backgroundColor >> 8 & 0xFF) / 255.0f;
        float k = (float)(GeneralOptions.backgroundColor & 0xFF) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < list.size(); ++i) {
            int j;
            int x2;
            int x1;
            int height = 9;
            int width = this.f_94031_.m_92895_(list.get(i).getString());
            int y = 2 + 9 * i;
            if (pos == PositionEnum.RIGHT) {
                windowWidth = (int)((double)this.f_94030_.m_91268_().m_85445_() / GeneralOptions.fontScale) - 2 - width;
                if (GeneralOptions.enableAnimations) {
                    windowWidth += Utils.xPos;
                }
                x1 = windowWidth - 1;
                x2 = windowWidth + width + 1;
            } else {
                windowWidth = 2;
                if (GeneralOptions.enableAnimations) {
                    windowWidth -= Utils.xPos;
                }
                x1 = 1 + windowWidth;
                x2 = width + 3 + windowWidth;
            }
            int y1 = y - 1;
            int y2 = y + 9 - 1;
            Matrix4f matrix = matrixStack.m_85850_().m_85861_();
            if (x1 < x2) {
                j = x1;
                x1 = x2;
                x2 = j;
            }
            if (y1 < y2) {
                j = y1;
                y1 = y2;
                y2 = j;
            }
            bufferBuilder.m_85982_(matrix, (float)x1, (float)y2, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, (float)x2, (float)y1, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_85982_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(g, h, k, f).m_5752_();
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        return MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
    }

    @Inject(method={"renderLeftText"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderLeftText(PoseStack matrixStack, CallbackInfo ci) {
        if (GeneralOptions.disableMod) {
            return;
        }
        List<Component> list = this.newLeftText();
        MultiBufferSource.BufferSource immediate = this.immediate(PositionEnum.LEFT, list, matrixStack);
        for (int i = 0; i < list.size(); ++i) {
            if (Strings.isNullOrEmpty((String)list.get(i).getString())) continue;
            int height = 9;
            int y = 2 + 9 * i;
            int xPosLeft = 2;
            if (GeneralOptions.enableAnimations) {
                xPosLeft -= Utils.xPos;
            }
            this.f_94031_.m_92841_(list.get(i), (float)xPosLeft, (float)y, 0xE0E0E0, GeneralOptions.shadowText, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)immediate, false, 0, 0xF000F0);
        }
        immediate.m_109911_();
        ci.cancel();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void renderBefore(PoseStack matrices, CallbackInfo ci) {
        matrices.m_85836_();
        if (this.f_94030_.f_91066_.f_92065_) {
            int scaledWidth = this.f_94030_.m_91268_().m_85445_();
            this.m_94058_(matrices, this.f_94030_.m_91293_(), 0, scaledWidth / 2, true);
            IntegratedServer integratedServer = this.f_94030_.m_91092_();
            if (integratedServer != null) {
                this.m_94058_(matrices, integratedServer.m_129904_(), scaledWidth - Math.min(scaledWidth / 2, 240), scaledWidth / 2, false);
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/DebugHud;renderLeftText(Lnet/minecraft/client/util/math/MatrixStack;)V")})
    public void renderFontScaleBefore(PoseStack matrices, CallbackInfo ci) {
        if (!GeneralOptions.disableMod) {
            matrices.m_85841_((float)GeneralOptions.fontScale, (float)GeneralOptions.fontScale, 1.0f);
        }
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/option/GameOptions;debugTpsEnabled:Z")}, cancellable=true)
    public void renderFontScaleRightAfter(PoseStack matrices, CallbackInfo ci) {
        matrices.m_85849_();
        this.f_94030_.m_91307_().m_7238_();
        ci.cancel();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void renderAnimation(PoseStack matrices, CallbackInfo ci) {
        if (!GeneralOptions.enableAnimations) {
            return;
        }
        long time = Util.m_137550_();
        if (time - Utils.lastAnimationUpdate >= 10L && (Utils.xPos != 0 || Utils.closingAnimation)) {
            int i = (100 + Utils.xPos) / 10 - 9;
            if (Utils.xPos != 0 && !Utils.closingAnimation) {
                Utils.xPos = (int)((double)Utils.xPos / GeneralOptions.animationSpeed);
                Utils.xPos -= i;
            }
            if (i == 0) {
                i = 1;
            }
            if (Utils.closingAnimation) {
                Utils.xPos += i;
                if ((Utils.xPos = (int)((double)Utils.xPos * GeneralOptions.animationSpeed)) >= 300) {
                    this.f_94030_.f_91066_.f_92063_ = false;
                    Utils.closingAnimation = false;
                }
            }
            Utils.lastAnimationUpdate = time;
        }
    }
}

