/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import net.caffeinemc.phosphor.common.chunk.light.SkyLightStorageAccess;
import net.caffeinemc.phosphor.common.util.LightUtil;
import net.caffeinemc.phosphor.common.util.math.ChunkSectionPosHelper;
import net.caffeinemc.phosphor.common.util.math.DirectionHelper;
import net.caffeinemc.phosphor.mixin.chunk.light.MixinChunkLightProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.SkyLightEngine;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SkyLightEngine.class})
public abstract class MixinChunkSkyLightProvider
extends MixinChunkLightProvider {
    private static final BlockState AIR_BLOCK = Blocks.f_50016_.m_49966_();
    @Shadow
    @Final
    private static Direction[] f_75840_;
    @Shadow
    @Final
    private static Direction[] f_75839_;

    @Override
    @Overwrite
    public int m_6359_(long fromId, long toId, int currentLevel) {
        return this.getPropagatedLevel(fromId, null, toId, currentLevel);
    }

    @Override
    public int getPropagatedLevel(long fromId, BlockState fromState, long toId, int currentLevel) {
        VoxelShape fromShape;
        VoxelShape toShape;
        if (toId == Long.MAX_VALUE || fromId == Long.MAX_VALUE) {
            return 15;
        }
        if (currentLevel >= 15) {
            return currentLevel;
        }
        int toX = BlockPos.m_121983_((long)toId);
        int toY = BlockPos.m_122008_((long)toId);
        int toZ = BlockPos.m_122015_((long)toId);
        BlockState toState = this.getBlockStateForLighting(toX, toY, toZ);
        int fromX = BlockPos.m_121983_((long)fromId);
        int fromY = BlockPos.m_122008_((long)fromId);
        int fromZ = BlockPos.m_122015_((long)fromId);
        if (fromState == null) {
            fromState = this.getBlockStateForLighting(fromX, fromY, fromZ);
        }
        boolean airPropagation = toState == AIR_BLOCK && fromState == AIR_BLOCK;
        boolean verticalOnly = fromX == toX && fromZ == toZ;
        Direction dir = DirectionHelper.getVecDirection(toX - fromX, toY - fromY, toZ - fromZ);
        if (dir == null) {
            throw new IllegalStateException(String.format("Light was spread in illegal direction %d, %d, %d", Integer.signum(toX - fromX), Integer.signum(toY - fromY), Integer.signum(toZ - fromZ)));
        }
        if (!airPropagation && (toShape = this.getOpaqueShape(toState, toX, toY, toZ, dir.m_122424_())) != Shapes.m_83144_() && LightUtil.unionCoversFullCube(fromShape = this.getOpaqueShape(fromState, fromX, fromY, fromZ, dir), toShape)) {
            return 15;
        }
        int out = this.getSubtractedLight(toState, toX, toY, toZ);
        if (out == 0 && currentLevel == 0 && verticalOnly && fromY > toY) {
            return 0;
        }
        return currentLevel + Math.max(1, out);
    }

    @Overwrite
    public void m_7900_(long id, int targetLevel, boolean mergeAsMin) {
        int aboveY;
        int aboveChunkY;
        int belowY;
        int belowChunkY;
        long chunkId = SectionPos.m_123235_((long)id);
        int x = BlockPos.m_121983_((long)id);
        int y = BlockPos.m_122008_((long)id);
        int z = BlockPos.m_122015_((long)id);
        int localX = SectionPos.m_123207_((int)x);
        int localY = SectionPos.m_123207_((int)y);
        int localZ = SectionPos.m_123207_((int)z);
        BlockState fromState = this.getBlockStateForLighting(x, y, z);
        if (localX > 0 && localX < 15 && localY > 0 && localY < 15 && localZ > 0 && localZ < 15) {
            for (Direction dir : f_75839_) {
                this.propagateLevel(id, fromState, BlockPos.m_121882_((int)(x + dir.m_122429_()), (int)(y + dir.m_122430_()), (int)(z + dir.m_122431_())), targetLevel, mergeAsMin);
            }
            return;
        }
        int chunkY = SectionPos.m_123171_((int)y);
        int chunkOffsetY = 0;
        if (localY == 0) {
            while (!this.hasSection(SectionPos.m_123186_((long)chunkId, (int)0, (int)(-chunkOffsetY - 1), (int)0)) && ((SkyLightStorageAccess)this.f_75632_).callIsAboveMinHeight(chunkY - chunkOffsetY - 1)) {
                ++chunkOffsetY;
            }
        }
        if (chunkY == (belowChunkY = SectionPos.m_123171_((int)(belowY = y + (-1 - chunkOffsetY * 16)))) || this.hasSection(ChunkSectionPosHelper.updateYLong(chunkId, belowChunkY))) {
            BlockState state = chunkY == belowChunkY ? fromState : AIR_BLOCK;
            this.propagateLevel(BlockPos.m_121882_((int)x, (int)(belowY + 1), (int)z), state, BlockPos.m_121882_((int)x, (int)belowY, (int)z), targetLevel, mergeAsMin);
        }
        if (chunkY == (aboveChunkY = SectionPos.m_123171_((int)(aboveY = y + 1))) || this.hasSection(ChunkSectionPosHelper.updateYLong(chunkId, aboveChunkY))) {
            this.propagateLevel(id, fromState, BlockPos.m_121882_((int)x, (int)aboveY, (int)z), targetLevel, mergeAsMin);
        }
        for (Direction dir : f_75840_) {
            boolean isWithinOriginChunk;
            int adjZ;
            int adjX = x + dir.m_122429_();
            long offsetId = BlockPos.m_121882_((int)adjX, (int)y, (int)(adjZ = z + dir.m_122431_()));
            long offsetChunkId = SectionPos.m_123235_((long)offsetId);
            boolean bl = isWithinOriginChunk = chunkId == offsetChunkId;
            if (isWithinOriginChunk || this.hasSection(offsetChunkId)) {
                this.propagateLevel(id, fromState, offsetId, targetLevel, mergeAsMin);
            }
            if (isWithinOriginChunk) continue;
            for (int offsetChunkY = chunkY - 1; offsetChunkY > belowChunkY; --offsetChunkY) {
                if (!this.hasSection(ChunkSectionPosHelper.updateYLong(offsetChunkId, offsetChunkY))) continue;
                for (int offsetY = 15; offsetY >= 0; --offsetY) {
                    int adjY = SectionPos.m_123223_((int)offsetChunkY) + offsetY;
                    offsetId = BlockPos.m_121882_((int)adjX, (int)adjY, (int)adjZ);
                    this.propagateLevel(BlockPos.m_121882_((int)x, (int)adjY, (int)z), AIR_BLOCK, offsetId, targetLevel, mergeAsMin);
                }
            }
        }
    }

    @Override
    @Overwrite
    public void m_6185_(long id) {
        super.m_6185_(id);
    }
}

