/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.pathfinder.Node;
import tcb.spiderstpo.common.entity.movement.AdvancedWalkNodeProcessor;

public class DirectionalPathPoint
extends Node {
    protected static final long ALL_DIRECTIONS = AdvancedWalkNodeProcessor.packDirection(Direction.UP, AdvancedWalkNodeProcessor.packDirection(Direction.DOWN, AdvancedWalkNodeProcessor.packDirection(Direction.NORTH, AdvancedWalkNodeProcessor.packDirection(Direction.EAST, AdvancedWalkNodeProcessor.packDirection(Direction.SOUTH, AdvancedWalkNodeProcessor.packDirection(Direction.WEST, 0L))))));
    protected static final Direction[] DIRECTIONS = Direction.values();
    private final Direction[] pathableSides;
    private final Direction pathSide;
    private final boolean isDrop;

    public DirectionalPathPoint(int x, int y, int z, long packed, boolean isDrop) {
        super(x, y, z);
        EnumSet<Direction> directionsSet = EnumSet.noneOf(Direction.class);
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Direction dir = DIRECTIONS[i];
            if (!AdvancedWalkNodeProcessor.unpackDirection(dir, packed)) continue;
            directionsSet.add(dir);
        }
        this.pathableSides = directionsSet.toArray(new Direction[0]);
        this.pathSide = null;
        this.isDrop = isDrop;
    }

    public DirectionalPathPoint(Node point, long packed, boolean isDrop) {
        this(point.f_77271_, point.f_77272_, point.f_77273_, packed, isDrop);
        this.f_77274_ = point.f_77274_;
        this.f_77275_ = point.f_77275_;
        this.f_77276_ = point.f_77276_;
        this.f_77277_ = point.f_77277_;
        this.f_77278_ = point.f_77278_;
        this.f_77279_ = point.f_77279_;
        this.f_77280_ = point.f_77280_;
        this.f_77281_ = point.f_77281_;
        this.f_77282_ = point.f_77282_;
    }

    public DirectionalPathPoint(Node point) {
        this(point, ALL_DIRECTIONS, false);
    }

    private DirectionalPathPoint(int x, int y, int z, Direction[] pathableSides, Direction pathSide, boolean isDrop) {
        super(x, y, z);
        this.pathableSides = new Direction[pathableSides.length];
        System.arraycopy(pathableSides, 0, this.pathableSides, 0, pathableSides.length);
        this.pathSide = pathSide;
        this.isDrop = isDrop;
    }

    public DirectionalPathPoint(Node point, Direction pathSide) {
        super(point.f_77271_, point.f_77272_, point.f_77273_);
        this.f_77274_ = point.f_77274_;
        this.f_77275_ = point.f_77275_;
        this.f_77276_ = point.f_77276_;
        this.f_77277_ = point.f_77277_;
        this.f_77278_ = point.f_77278_;
        this.f_77279_ = point.f_77279_;
        this.f_77280_ = point.f_77280_;
        this.f_77281_ = point.f_77281_;
        this.f_77282_ = point.f_77282_;
        if (point instanceof DirectionalPathPoint) {
            DirectionalPathPoint other = (DirectionalPathPoint)point;
            this.pathableSides = new Direction[other.pathableSides.length];
            System.arraycopy(other.pathableSides, 0, this.pathableSides, 0, other.pathableSides.length);
            this.isDrop = other.isDrop;
        } else {
            this.pathableSides = Direction.values();
            this.isDrop = false;
        }
        this.pathSide = pathSide;
    }

    public DirectionalPathPoint assignPathSide(Direction pathDirection) {
        return new DirectionalPathPoint(this, pathDirection);
    }

    public Node m_77289_(int x, int y, int z) {
        DirectionalPathPoint pathPoint = new DirectionalPathPoint(x, y, z, this.pathableSides, this.pathSide, this.isDrop);
        pathPoint.f_77274_ = this.f_77274_;
        pathPoint.f_77275_ = this.f_77275_;
        pathPoint.f_77276_ = this.f_77276_;
        pathPoint.f_77277_ = this.f_77277_;
        pathPoint.f_77278_ = this.f_77278_;
        pathPoint.f_77279_ = this.f_77279_;
        pathPoint.f_77280_ = this.f_77280_;
        pathPoint.f_77281_ = this.f_77281_;
        pathPoint.f_77282_ = this.f_77282_;
        return pathPoint;
    }

    public Direction[] getPathableSides() {
        return this.pathableSides;
    }

    @Nullable
    public Direction getPathSide() {
        return this.pathSide;
    }

    public boolean isDrop() {
        return this.isDrop;
    }
}

