/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NoFilteringEntry
extends AbstractConfigListEntry<List<EntryStack<?>>> {
    private int width;
    private Consumer<List<EntryStack<?>>> saveConsumer;
    private List<EntryStack<?>> defaultValue;
    private List<EntryStack<?>> configFiltered;
    private final AbstractWidget buttonWidget = new Button(0, 0, 0, 20, (Component)new TranslatableComponent("config.roughlyenoughitems.filteredEntries.loadWorldFirst"), button -> {});
    private final List<AbstractWidget> children = ImmutableList.of((Object)this.buttonWidget);

    public NoFilteringEntry(int width, List<EntryStack<?>> configFiltered, List<EntryStack<?>> defaultValue, Consumer<List<EntryStack<?>>> saveConsumer) {
        super(NarratorChatListener.f_93310_, false);
        this.width = width;
        this.configFiltered = configFiltered;
        this.defaultValue = defaultValue;
        this.saveConsumer = saveConsumer;
    }

    public List<EntryStack<?>> getValue() {
        return this.configFiltered;
    }

    public Optional<List<EntryStack<?>>> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    public void save() {
        this.saveConsumer.accept((List<EntryStack<?>>)this.getValue());
    }

    public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        Window window = Minecraft.m_91087_().m_91268_();
        this.buttonWidget.f_93623_ = false;
        this.buttonWidget.f_93621_ = y;
        this.buttonWidget.f_93620_ = x + entryWidth / 2 - this.width / 2;
        this.buttonWidget.m_93674_(this.width);
        this.buttonWidget.m_6305_(matrices, mouseX, mouseY, delta);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    public List<? extends NarratableEntry> narratables() {
        return this.children;
    }
}

