/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.changelog;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.gui.changelog.ChangelogLoader;
import me.shedaniel.rei.impl.client.gui.changelog.JParseDown;
import me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class JParseDownToMinecraft {
    public static Component toComponent(JParseDown.Inline inline) {
        if (inline instanceof JParseDown.InlineText) {
            return new TextComponent(((JParseDown.InlineText)inline).text.replace("\n", " "));
        }
        if (inline instanceof JParseDown.InlineBold) {
            return new TextComponent(((JParseDown.InlineBold)inline).text.replace("\n", " ")).m_130940_(ChatFormatting.BOLD);
        }
        if (inline instanceof JParseDown.InlineItalic) {
            return new TextComponent(((JParseDown.InlineItalic)inline).text.replace("\n", " ")).m_130940_(ChatFormatting.ITALIC);
        }
        if (inline instanceof JParseDown.InlineLink) {
            return new TextComponent(((JParseDown.InlineLink)inline).text.replace("\n", " ")).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)2081791)).m_131162_(Boolean.valueOf(true)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(((JParseDown.InlineLink)inline).url).m_130940_(ChatFormatting.GRAY))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, ((JParseDown.InlineLink)inline).url)));
        }
        if (inline instanceof JParseDown.InlineStrikeThrough) {
            return new TextComponent(((JParseDown.InlineStrikeThrough)inline).text.replace("\n", " ")).m_130940_(ChatFormatting.STRIKETHROUGH);
        }
        return null;
    }

    public static void build(ChangelogLoader.Builder builder, JParseDown.Block block) {
        ImmutableTextComponent lastComponent = ImmutableTextComponent.EMPTY;
        ChangelogLoader.Builder finalBuilder = builder;
        for (JParseDown.Inline inline : block.inlines) {
            InputStream stream;
            Component component = JParseDownToMinecraft.toComponent(inline);
            if (component != null) {
                lastComponent = lastComponent.m_7220_(component);
                continue;
            }
            builder.add((Component)lastComponent);
            lastComponent = ImmutableTextComponent.EMPTY;
            if (inline instanceof JParseDown.InlineLineBreak) continue;
            if (inline instanceof JParseDown.InlineHorizontalRule) {
                builder.add(ErrorsEntryListWidget.HorizontalRuleEntry::new);
                continue;
            }
            if (!(inline instanceof JParseDown.InlineImage) || (stream = builder.getClass().getClassLoader().getResourceAsStream(((JParseDown.InlineImage)inline).src)) == null) continue;
            try {
                DynamicTexture texture = new DynamicTexture(NativeImage.m_85058_((InputStream)stream));
                ResourceLocation id = Minecraft.m_91087_().m_91097_().m_118490_("rei_md_image_", texture);
                builder.add(width -> new ErrorsEntryListWidget.ImageEntry((int)width, texture, id));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (lastComponent != ImmutableTextComponent.EMPTY) {
            builder.add((Component)lastComponent);
        }
    }
}

