/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubMenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Menu
extends WidgetWithBounds
implements LateRenderable {
    public static final UUID WEATHER = UUID.randomUUID();
    public static final UUID GAME_TYPE = UUID.randomUUID();
    public final Point menuStartPoint;
    public final boolean facingRight;
    public final boolean facingDownwards;
    private final List<MenuEntry> entries = Lists.newArrayList();
    public final ScrollingContainer scrolling = new ScrollingContainer(){

        public int getMaxScrollHeight() {
            int i = 0;
            for (MenuEntry entry : Menu.this.m_6702_()) {
                i += entry.getEntryHeight();
            }
            return i;
        }

        public Rectangle getBounds() {
            return Menu.this.getInnerBounds();
        }

        public boolean hasScrollBar() {
            return Menu.this.hasScrollBar();
        }
    };

    public Menu(Rectangle menuStart, Collection<MenuEntry> entries, boolean sort) {
        this.buildEntries(entries, sort);
        int fullWidth = Minecraft.m_91087_().f_91080_.f_96543_;
        int fullHeight = Minecraft.m_91087_().f_91080_.f_96544_;
        boolean facingRight = true;
        this.facingDownwards = fullHeight - menuStart.getMaxY() > menuStart.y;
        int y = this.facingDownwards ? menuStart.getMaxY() : menuStart.y - (this.scrolling.getMaxScrollHeight() + 2);
        boolean hasScrollBar = this.scrolling.getMaxScrollHeight() > this.getInnerHeight(y);
        int menuWidth = this.getMaxEntryWidth() + 2 + (hasScrollBar ? 6 : 0);
        if (facingRight && fullWidth - menuStart.getMaxX() < menuWidth + 10) {
            facingRight = false;
        } else if (!facingRight && menuStart.x < menuWidth + 10) {
            facingRight = true;
        }
        this.facingRight = facingRight;
        int x = facingRight ? menuStart.x : menuStart.getMaxX() - (this.getMaxEntryWidth() + 2 + (hasScrollBar ? 6 : 0));
        this.menuStartPoint = new Point(x, y);
    }

    private void buildEntries(Collection<MenuEntry> entries, boolean sort) {
        this.entries.clear();
        this.entries.addAll(entries);
        if (sort) {
            this.entries.sort(Comparator.comparing(entry -> entry instanceof SubMenuEntry ? 0 : 1).thenComparing(entry -> {
                String string;
                if (entry instanceof SubMenuEntry) {
                    SubMenuEntry menuEntry = (SubMenuEntry)entry;
                    string = menuEntry.text.getString();
                } else {
                    string = "";
                }
                return string;
            }));
        }
        for (MenuEntry entry2 : this.entries) {
            entry2.parent = this;
        }
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.menuStartPoint.x, this.menuStartPoint.y, this.getMaxEntryWidth() + 2 + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight(this.menuStartPoint.y) + 2);
    }

    public Rectangle getInnerBounds() {
        return new Rectangle(this.menuStartPoint.x + 1, this.menuStartPoint.y + 1, this.getMaxEntryWidth() + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight(this.menuStartPoint.y));
    }

    public boolean hasScrollBar() {
        return this.scrolling.getMaxScrollHeight() > this.getInnerHeight(this.menuStartPoint.y);
    }

    public int getInnerHeight(int y) {
        return Math.min(this.scrolling.getMaxScrollHeight(), this.minecraft.f_91080_.f_96544_ - 20 - y);
    }

    public int getMaxEntryWidth() {
        int i = 0;
        for (MenuEntry entry : this.m_6702_()) {
            if (entry.getEntryWidth() <= i) continue;
            i = entry.getEntryWidth();
        }
        return Math.max(10, i);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        MenuEntry menuEntry;
        Rectangle bounds = this.getBounds();
        Rectangle innerBounds = this.getInnerBounds();
        Menu.m_93172_((PoseStack)matrices, (int)bounds.x, (int)bounds.y, (int)bounds.getMaxX(), (int)bounds.getMaxY(), (int)(this.containsMouse(mouseX, mouseY) ? (REIRuntime.getInstance().isDarkThemeEnabled() ? -17587 : -1) : -6250336));
        Menu.m_93172_((PoseStack)matrices, (int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)-16777216);
        boolean contains = innerBounds.contains(mouseX, mouseY);
        GuiEventListener guiEventListener = this.m_7222_();
        MenuEntry focused = guiEventListener instanceof MenuEntry ? (menuEntry = (MenuEntry)guiEventListener) : null;
        int currentY = innerBounds.y - this.scrolling.scrollAmountInt();
        for (MenuEntry child : this.m_6702_()) {
            boolean containsMouse;
            boolean bl = containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            if (containsMouse) {
                focused = child;
            }
            currentY += child.getEntryHeight();
        }
        currentY = innerBounds.y - this.scrolling.scrollAmountInt();
        ScissorsHandler.INSTANCE.scissor(this.scrolling.getScissorBounds());
        for (MenuEntry child : this.m_6702_()) {
            boolean rendering = currentY + child.getEntryHeight() >= innerBounds.y && currentY <= innerBounds.getMaxY();
            boolean containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            child.updateInformation(innerBounds.x, currentY, focused == child || containsMouse, containsMouse, rendering, this.getMaxEntryWidth());
            if (rendering) {
                child.m_6305_(matrices, mouseX, mouseY, delta);
            }
            currentY += child.getEntryHeight();
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.m_7522_((GuiEventListener)focused);
        this.scrolling.renderScrollBar(0, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        this.scrolling.updatePosition(delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button) || this.getInnerBounds().contains(mouseX, mouseY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.getInnerBounds().contains(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        for (MenuEntry child : this.m_6702_()) {
            if (!(child instanceof SubMenuEntry) || !child.m_6050_(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        if (super.containsMouse(mouseX, mouseY)) {
            return true;
        }
        for (MenuEntry child : this.m_6702_()) {
            if (!child.containsMouse(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public List<MenuEntry> m_6702_() {
        return this.entries;
    }
}

