/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import dev.architectury.fluid.FluidStack;
import dev.architectury.utils.value.IntValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.TabContainerWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDisplayViewingScreen
extends Screen
implements DisplayScreen {
    protected final Map<DisplayCategory<?>, List<DisplaySpec>> categoryMap;
    protected final List<DisplayCategory<?>> categories;
    protected final TabContainerWidget tabs = new TabContainerWidget();
    protected List<EntryStack<?>> ingredientStackToNotice = new ArrayList();
    protected List<EntryStack<?>> resultStackToNotice = new ArrayList();
    protected int selectedCategoryIndex = 0;
    protected int categoryPages = -1;
    protected Rectangle bounds;
    private static final int MAX_WIDTH = 200;

    protected AbstractDisplayViewingScreen(Map<DisplayCategory<?>, List<DisplaySpec>> categoryMap, @Nullable CategoryIdentifier<?> category) {
        super(NarratorChatListener.f_93310_);
        this.categoryMap = categoryMap;
        this.categories = Lists.newArrayList(categoryMap.keySet());
        if (category != null) {
            this.selectCategory(category, false);
        }
    }

    protected void selectCategory(CategoryIdentifier<?> category) {
        this.selectCategory(category, true);
    }

    protected void selectCategory(CategoryIdentifier<?> category, boolean init) {
        for (int i = 0; i < this.categories.size(); ++i) {
            if (!this.categories.get(i).getCategoryIdentifier().equals(category)) continue;
            this.selectedCategoryIndex = i;
            break;
        }
        this.recalculateCategoryPage();
        this.tabs.updateScroll(this.categories, this.selectedCategoryIndex, !init ? 0L : 300L);
        if (init) {
            this.m_7856_();
        }
    }

    @Override
    public void recalculateCategoryPage() {
        this.categoryPages = -1;
    }

    protected void initTabs(int width) {
        this.tabs.init(new Rectangle(this.bounds.getCenterX() - width / 2, this.bounds.y - 28, width, 28), new Rectangle(this.bounds.getCenterX() - width / 2, this.bounds.y - 28, width, 28), this.categories, new IntValue(){

            public void accept(int value) {
                AbstractDisplayViewingScreen.this.categoryPages = value;
            }

            public int getAsInt() {
                return AbstractDisplayViewingScreen.this.categoryPages;
            }
        }, new IntValue(){

            public void accept(int value) {
                AbstractDisplayViewingScreen.this.selectCategory(AbstractDisplayViewingScreen.this.categories.get(value).getCategoryIdentifier());
            }

            public int getAsInt() {
                return AbstractDisplayViewingScreen.this.selectedCategoryIndex;
            }
        }, () -> ((AbstractDisplayViewingScreen)this).m_7856_());
    }

    public List<GuiEventListener> m_6702_() {
        List children = super.m_6702_();
        children.sort(Comparator.comparingDouble(value -> {
            double d;
            if (value instanceof Widget) {
                Widget widget = (Widget)value;
                d = widget.getZRenderingPriority();
            } else {
                d = 0.0;
            }
            return d;
        }).reversed());
        return children;
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void addIngredientToNotice(EntryStack<?> stack) {
        if (stack == null) {
            return;
        }
        this.ingredientStackToNotice.add(stack);
    }

    @Override
    public void addResultToNotice(EntryStack<?> stack) {
        if (stack == null) {
            return;
        }
        this.resultStackToNotice.add(stack);
    }

    @Override
    public List<EntryStack<?>> getIngredientsToNotice() {
        return Collections.unmodifiableList(this.ingredientStackToNotice);
    }

    @Override
    public List<EntryStack<?>> getResultsToNotice() {
        return Collections.unmodifiableList(this.resultStackToNotice);
    }

    @Override
    public DisplayCategory<Display> getCurrentCategory() {
        return this.categories.get(this.selectedCategoryIndex);
    }

    protected DisplayCategoryView<Display> getCurrentCategoryView(Display display) {
        return CategoryRegistry.getInstance().get(display.getCategoryIdentifier().cast()).getView(display);
    }

    @Override
    public void previousCategory() {
        int currentCategoryIndex = this.selectedCategoryIndex;
        if (--currentCategoryIndex < 0) {
            currentCategoryIndex = this.categories.size() - 1;
        }
        this.selectCategory(this.categories.get(currentCategoryIndex).getCategoryIdentifier());
    }

    @Override
    public void nextCategory() {
        int currentCategoryIndex = this.selectedCategoryIndex;
        if (++currentCategoryIndex >= this.categories.size()) {
            currentCategoryIndex = 0;
        }
        this.selectCategory(this.categories.get(currentCategoryIndex).getCategoryIdentifier());
    }

    protected void transformIngredientNotice(List<Widget> setupDisplay, List<EntryStack<?>> noticeStacks) {
        AbstractDisplayViewingScreen.transformNotice(1, setupDisplay, noticeStacks);
    }

    protected void transformResultNotice(List<Widget> setupDisplay, List<EntryStack<?>> noticeStacks) {
        AbstractDisplayViewingScreen.transformNotice(2, setupDisplay, noticeStacks);
    }

    private static void transformNotice(int marker, List<? extends GuiEventListener> setupDisplay, List<EntryStack<?>> noticeStacks) {
        if (noticeStacks.isEmpty()) {
            return;
        }
        block0: for (EntryWidget widget : Widgets.walk(setupDisplay, EntryWidget.class::isInstance)) {
            if (widget.getNoticeMark() != marker || widget.getEntries().size() <= 1) continue;
            for (EntryStack<?> noticeStack : noticeStacks) {
                EntryStack<?> stack = CollectionUtils.findFirstOrNullEqualsExact(widget.getEntries(), noticeStack);
                if (stack == null) continue;
                widget.clearStacks();
                widget.entry((EntryStack)stack);
                continue block0;
            }
        }
    }

    protected void transformFiltering(List<? extends GuiEventListener> setupDisplay) {
        for (EntryWidget widget : Widgets.walk(setupDisplay, EntryWidget.class::isInstance)) {
            Collection<EntryStack<?>> refiltered;
            if (widget.getEntries().size() <= 1 || (refiltered = EntryRegistry.getInstance().refilterNew(false, widget.getEntries())).isEmpty()) continue;
            widget.clearStacks();
            widget.entries(refiltered);
        }
    }

    protected void setupTags(List<Widget> widgets) {
        block0: for (EntryWidget widget : Widgets.walk(widgets, EntryWidget.class::isInstance)) {
            List<Holder> objects;
            DefaultedRegistry registry;
            if (widget.getNoticeMark() != 1) continue;
            this.addCyclingTooltip(widget);
            widget.removeTagMatch = false;
            if (widget.getEntries().size() <= 1) continue;
            EntryType<?> type = null;
            for (EntryStack<?> entry : widget.getEntries()) {
                if (type == null) {
                    type = entry.getType();
                    continue;
                }
                if (type == entry.getType()) continue;
                continue block0;
            }
            if (type == VanillaEntryTypes.ITEM) {
                registry = Registry.f_122827_;
                objects = CollectionUtils.map(widget.getEntries(), stack -> ((ItemStack)stack.castValue()).m_41720_().m_204114_());
            } else {
                if (type != VanillaEntryTypes.FLUID) continue;
                registry = Registry.f_122822_;
                objects = CollectionUtils.map(widget.getEntries(), stack -> ((FluidStack)stack.castValue()).getFluid().m_205069_());
            }
            Stream<TagKey> collection = registry.m_203612_().filter(pair -> ((HolderSet.Named)pair.getSecond()).m_203632_() == objects.size()).map(Pair::getFirst);
            TagKey firstOrNull = CollectionUtils.findFirstOrNull(collection::iterator, key -> CollectionUtils.allMatch(objects, holder -> holder.m_203656_(key)));
            if (firstOrNull == null) continue;
            widget.tagMatch = firstOrNull.f_203868_();
        }
    }

    private void addCyclingTooltip(final EntryWidget widget) {
        class TooltipProcessor
        implements UnaryOperator<Tooltip>,
        TooltipComponent,
        ClientTooltipComponent {
            TooltipProcessor() {
            }

            @Override
            public Tooltip apply(Tooltip tooltip) {
                if (widget.getEntries().size() > 1) {
                    for (Tooltip.Entry entry : tooltip.entries()) {
                        if (!entry.isTooltipComponent() || !(entry.getAsTooltipComponent() instanceof TooltipProcessor)) continue;
                        return tooltip;
                    }
                    tooltip.add(this);
                }
                return tooltip;
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof TooltipProcessor;
            }

            public int m_142103_() {
                int entrySize = EntryListWidget.entrySize();
                int w = Math.max(1, 200 / entrySize);
                int height = Math.min(6, Mth.m_14167_((float)((float)widget.getEntries().size() / (float)w))) * entrySize + 2;
                height += 12;
                if (widget.tagMatch != null) {
                    height += 12;
                }
                return height;
            }

            public int m_142069_(Font font) {
                int entrySize = EntryListWidget.entrySize();
                int w = Math.max(1, 200 / entrySize);
                int size = widget.getEntries().size();
                int width = Math.min(size, w) * entrySize;
                width = Math.max(width, font.m_92852_((FormattedText)new TranslatableComponent("text.rei.accepts")));
                if (widget.tagMatch != null) {
                    width = Math.max(width, font.m_92852_((FormattedText)new TranslatableComponent("text.rei.tag_accept", new Object[]{widget.tagMatch.toString()})));
                }
                return width;
            }

            public void m_183452_(Font font, int x, int y, PoseStack poses, ItemRenderer renderer, int z) {
                int entrySize = EntryListWidget.entrySize();
                int w = Math.max(1, 200 / entrySize);
                int i = 0;
                poses.m_85836_();
                poses.m_85837_(0.0, 0.0, (double)(z + 50));
                for (EntryStack<?> entry : widget.getEntries()) {
                    int x1 = x + i % w * entrySize;
                    int y1 = y + 13 + i / w * entrySize;
                    if (++i / w > 5) {
                        MultiBufferSource.BufferSource source = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                        MutableComponent text = new TextComponent("+" + (widget.getEntries().size() - w * 6 + 1)).m_130940_(ChatFormatting.GRAY);
                        font.m_92841_((Component)text, (float)(x1 + entrySize / 2 - font.m_92852_((FormattedText)text) / 2), (float)(y1 + entrySize / 2 - 1), -1, true, poses.m_85850_().m_85861_(), (MultiBufferSource)source, false, 0, 0xF000F0);
                        source.m_109911_();
                        break;
                    }
                    entry.render(poses, new Rectangle(x1, y1, entrySize, entrySize), -1000, -1000, 0.0f);
                }
                poses.m_85849_();
            }

            public void m_142440_(Font font, int x, int y, Matrix4f pose, MultiBufferSource.BufferSource buffers) {
                font.m_92841_((Component)new TranslatableComponent("text.rei.accepts").m_130940_(ChatFormatting.GRAY), (float)x, (float)(y + 2), -1, true, pose, (MultiBufferSource)buffers, false, 0, 0xF000F0);
                if (widget.tagMatch != null) {
                    int entrySize = EntryListWidget.entrySize();
                    int w = Math.max(1, 200 / entrySize);
                    font.m_92841_((Component)new TranslatableComponent("text.rei.tag_accept", new Object[]{widget.tagMatch.toString()}).m_130940_(ChatFormatting.GRAY), (float)x, (float)(y + 16 + Math.min(6, Mth.m_14167_((float)((float)widget.getEntries().size() / (float)w))) * entrySize), -1, true, pose, (MultiBufferSource)buffers, false, 0, 0xF000F0);
                }
            }
        }
        widget.tooltipProcessor(new TooltipProcessor());
    }

    protected static ScreenOverlay getOverlay() {
        return REIRuntime.getInstance().getOverlay().orElseThrow(() -> new IllegalStateException("Overlay not initialized!"));
    }

    private boolean handleFocuses(int button) {
        if (button == 0) {
            this.m_7897_(true);
        }
        this.handleFocuses();
        return true;
    }

    private boolean handleFocuses() {
        if (this.m_7222_() instanceof ScreenOverlay || this.m_7222_() == this) {
            this.m_7522_(null);
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button) || AbstractDisplayViewingScreen.getOverlay().m_6375_(mouseX, mouseY, button) && this.handleFocuses(button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button) || AbstractDisplayViewingScreen.getOverlay().m_6348_(mouseX, mouseY, button) && this.handleFocuses();
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY) || AbstractDisplayViewingScreen.getOverlay().m_7979_(mouseX, mouseY, button, deltaX, deltaY) && this.handleFocuses();
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return super.m_6050_(mouseX, mouseY, amount) || AbstractDisplayViewingScreen.getOverlay().m_6050_(mouseX, mouseY, amount) && this.handleFocuses();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers) || AbstractDisplayViewingScreen.getOverlay().m_7933_(keyCode, scanCode, modifiers) && this.handleFocuses()) {
            return true;
        }
        if (ConfigObject.getInstance().getPreviousScreenKeybind().matchesKey(keyCode, scanCode)) {
            if (REIRuntimeImpl.getInstance().hasLastDisplayScreen()) {
                this.f_96541_.m_91152_(REIRuntimeImpl.getInstance().getLastDisplayScreen());
            } else {
                this.f_96541_.m_91152_(REIRuntime.getInstance().getPreviousScreen());
            }
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            Minecraft.m_91087_().m_91152_(REIRuntime.getInstance().getPreviousScreen());
            return true;
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return super.m_7920_(keyCode, scanCode, modifiers) || AbstractDisplayViewingScreen.getOverlay().m_7920_(keyCode, scanCode, modifiers) && this.handleFocuses();
    }

    public boolean m_5534_(char character, int modifiers) {
        return super.m_5534_(character, modifiers) || AbstractDisplayViewingScreen.getOverlay().m_5534_(character, modifiers) && this.handleFocuses();
    }
}

