/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.changelog.ChangelogLoader;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.CachedEntryListRender;
import me.shedaniel.rei.impl.client.gui.widget.DefaultDisplayChoosePageWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CachingEntryRenderer;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.CollapsingEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListStackEntry;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PaginatedEntryListWidget
extends CollapsingEntryListWidget {
    private Button leftButton;
    private Button rightButton;
    private Button changelogButton;
    private List<Widget> additionalWidgets;
    private List<Object> stacks = new ArrayList<Object>();
    protected List<EntryListStackEntry> entries = Collections.emptyList();
    private int page;

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    protected void renderEntries(boolean fastEntryRendering, PoseStack matrices, int mouseX, int mouseY, float delta) {
        BatchedEntryRendererManager manager;
        this.leftButton.setEnabled(this.getTotalPages() > 1);
        this.rightButton.setEnabled(this.getTotalPages() > 1);
        if (ConfigObject.getInstance().doesCacheEntryRendering()) {
            for (EntryListStackEntry entry : this.entries) {
                CachedEntryListRender.Sprite sprite;
                CollapsedStack collapsedStack = entry.getCollapsedStack();
                if (collapsedStack != null && !collapsedStack.isExpanded() || entry.our != null || (sprite = CachedEntryListRender.get(entry.getCurrentEntry())) == null) continue;
                CachingEntryRenderer renderer = new CachingEntryRenderer(sprite, () -> ((PaginatedEntryListWidget)this).m_93252_());
                entry.our = ClientEntryStacks.setRenderer(entry.getCurrentEntry().copy().cast(), stack -> renderer);
            }
        }
        if ((manager = new BatchedEntryRendererManager()).isFastEntryRendering()) {
            for (EntryListStackEntry entry : this.entries) {
                CollapsedStack collapsedStack = entry.getCollapsedStack();
                if (collapsedStack != null && !collapsedStack.isExpanded()) {
                    manager.addSlow(entry);
                    continue;
                }
                manager.add(entry);
            }
        } else {
            manager.addAllSlow(this.entries);
        }
        manager.render(this.debugger.debugTime, this.debugger.size, this.debugger.time, matrices, mouseX, mouseY, delta);
        for (Widget widget : this.additionalWidgets) {
            widget.m_6305_(matrices, mouseX, mouseY, delta);
        }
    }

    public int getTotalPages() {
        return Mth.m_14167_((float)((float)this.stacks.size() / (float)this.entries.size()));
    }

    @Override
    protected void updateEntries(int entrySize, boolean zoomed) {
        this.page = Math.max(this.page, 0);
        ArrayList entries = Lists.newArrayList();
        int width = this.innerBounds.width / entrySize;
        int height = this.innerBounds.height / entrySize;
        for (int currentY = 0; currentY < height; ++currentY) {
            for (int currentX = 0; currentX < width; ++currentX) {
                int slotX = currentX * entrySize + this.innerBounds.x;
                int slotY = currentY * entrySize + this.innerBounds.y;
                if (!PaginatedEntryListWidget.notSteppingOnExclusionZones(slotX - 1, slotY - 1, entrySize, entrySize)) continue;
                entries.add((EntryListStackEntry)new EntryListStackEntry(this, slotX, slotY, entrySize, zoomed).noBackground());
            }
        }
        this.page = Math.max(Math.min(this.page, this.getTotalPages() - 1), 0);
        int skip = Math.max(0, this.page * entries.size());
        List subList = this.stacks.stream().skip(skip).limit(Math.max(0, entries.size() - Math.max(0, -this.page * entries.size()))).toList();
        Int2ObjectMap<CollapsedStack> indexedCollapsedStack = this.getCollapsedStackIndexed();
        for (int i = 0; i < subList.size(); ++i) {
            Object stack = subList.get(i);
            EntryListStackEntry entry = (EntryListStackEntry)entries.get(i + Math.max(0, -this.page * entries.size()));
            entry.clearStacks();
            if (stack instanceof EntryStack) {
                EntryStack entryStack = (EntryStack)stack;
                entry.entry(entryStack);
            } else {
                entry.entries((Collection)((List)stack));
            }
            CollapsedStack collapsedStack = (CollapsedStack)indexedCollapsedStack.get(i + skip);
            if (collapsedStack != null && collapsedStack.getIngredient().size() > 1) {
                entry.collapsed(collapsedStack);
                continue;
            }
            entry.collapsed(null);
        }
        this.entries = entries;
    }

    @Override
    public List<Object> getStacks() {
        return this.stacks;
    }

    @Override
    public void setStacks(List<Object> stacks) {
        this.stacks = stacks;
    }

    @Override
    public Stream<EntryStack<?>> getEntries() {
        return this.entries.stream().map(EntryWidget::getCurrentEntry);
    }

    @Override
    protected List<EntryListStackEntry> getEntryWidgets() {
        return this.entries;
    }

    @Override
    public List<? extends Widget> m_6702_() {
        return CollectionUtils.concatUnmodifiable(super.m_6702_(), this.additionalWidgets);
    }

    @Override
    public void init(ScreenOverlayImpl overlay) {
        Rectangle overlayBounds = overlay.getBounds();
        this.additionalWidgets = new ArrayList<Widget>();
        this.leftButton = Widgets.createButton(new Rectangle(overlayBounds.x, overlayBounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (Component)new TextComponent("")).onClick(button -> {
            this.setPage(this.getPage() - 1);
            if (this.getPage() < 0) {
                this.setPage(this.getTotalPages() - 1);
            }
            this.updateEntriesPosition();
        }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && overlay.isNotInExclusionZones(point.x, point.y)).tooltipLine((Component)new TranslatableComponent("text.rei.previous_page")).focusable(false);
        this.additionalWidgets.add(this.leftButton);
        this.additionalWidgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            helper.m_93250_(helper.m_93252_() + 1);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InternalTextures.ARROW_LEFT_TEXTURE);
            Rectangle bounds = this.leftButton.getBounds();
            matrices.m_85836_();
            PaginatedEntryListWidget.m_93133_((PoseStack)matrices, (int)(bounds.x + 4), (int)(bounds.y + 4), (float)0.0f, (float)0.0f, (int)8, (int)8, (int)8, (int)8);
            matrices.m_85849_();
            helper.m_93250_(helper.m_93252_() - 1);
        }));
        this.changelogButton = Widgets.createButton(new Rectangle(overlayBounds.getMaxX() - 18 - 18, overlayBounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (Component)new TextComponent("")).onClick(button -> ChangelogLoader.show()).containsMousePredicate((button, point) -> button.getBounds().contains(point) && overlay.isNotInExclusionZones(point.x, point.y)).tooltipLine((Component)new TranslatableComponent("text.rei.changelog.title")).focusable(false);
        this.additionalWidgets.add(this.changelogButton);
        this.additionalWidgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            helper.m_93250_(helper.m_93252_() + 1);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InternalTextures.CHEST_GUI_TEXTURE);
            Rectangle bounds = this.changelogButton.getBounds();
            matrices.m_85836_();
            matrices.m_85837_(0.5, 0.0, 0.0);
            helper.m_93228_(matrices, bounds.x + 1, bounds.y + 2, !ChangelogLoader.hasVisited() ? 28 : 14, 0, 14, 14);
            matrices.m_85849_();
            helper.m_93250_(helper.m_93252_() - 1);
        }));
        this.rightButton = Widgets.createButton(new Rectangle(overlayBounds.getMaxX() - 18, overlayBounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 5, 16, 16), (Component)new TextComponent("")).onClick(button -> {
            this.setPage(this.getPage() + 1);
            if (this.getPage() >= this.getTotalPages()) {
                this.setPage(0);
            }
            this.updateEntriesPosition();
        }).containsMousePredicate((button, point) -> button.getBounds().contains(point) && overlay.isNotInExclusionZones(point.x, point.y)).tooltipLine((Component)new TranslatableComponent("text.rei.next_page")).focusable(false);
        this.additionalWidgets.add(this.rightButton);
        this.additionalWidgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            helper.m_93250_(helper.m_93252_() + 1);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InternalTextures.ARROW_RIGHT_TEXTURE);
            Rectangle bounds = this.rightButton.getBounds();
            matrices.m_85836_();
            PaginatedEntryListWidget.m_93133_((PoseStack)matrices, (int)(bounds.x + 4), (int)(bounds.y + 4), (float)0.0f, (float)0.0f, (int)8, (int)8, (int)8, (int)8);
            matrices.m_85849_();
            helper.m_93250_(helper.m_93252_() - 1);
        }));
        this.additionalWidgets.add(Widgets.createClickableLabel(new Point(overlayBounds.x + (overlayBounds.width - 18) / 2, overlayBounds.y + (ConfigObject.getInstance().getSearchFieldLocation() == SearchFieldLocation.TOP_SIDE ? 24 : 0) + 10), NarratorChatListener.f_93310_, label -> {
            if (!Screen.m_96638_()) {
                this.setPage(0);
                this.updateEntriesPosition();
            } else {
                ScreenOverlayImpl.getInstance().choosePageWidget = new DefaultDisplayChoosePageWidget(page -> {
                    this.setPage(page);
                    this.updateEntriesPosition();
                }, this.getPage(), this.getTotalPages());
            }
        }).tooltip(new Component[]{new TranslatableComponent("text.rei.go_back_first_page"), new TextComponent(" "), new TranslatableComponent("text.rei.shift_click_to", new Object[]{new TranslatableComponent("text.rei.choose_page")}).m_130940_(ChatFormatting.GRAY)}).focusable(false).onRender((matrices, label) -> {
            label.setClickable(this.getTotalPages() > 1);
            label.setMessage((FormattedText)new TextComponent(String.format("%s/%s", this.getPage() + 1, Math.max(this.getTotalPages(), 1))));
        }).rainbow((double)new Random().nextFloat() < 1.0E-4 || (Boolean)ClientHelperImpl.getInstance().isAprilFools.m_13971_() != false));
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (super.m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        if (!Screen.m_96637_()) {
            if (amount > 0.0 && this.leftButton.isEnabled()) {
                this.leftButton.onClick();
            } else if (amount < 0.0 && this.rightButton.isEnabled()) {
                this.rightButton.onClick();
            } else {
                return false;
            }
            return true;
        }
        return false;
    }
}

