/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.display;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import dev.architectury.event.EventResult;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReason;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReasons;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.registry.RecipeManagerContextImpl;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayRegistryImpl
extends RecipeManagerContextImpl<REIClientPlugin>
implements DisplayRegistry {
    private final WeakHashMap<Display, Object> displaysBase = new WeakHashMap();
    private final Map<CategoryIdentifier<?>, DisplaysList> displays = new ConcurrentHashMap();
    private final Map<CategoryIdentifier<?>, List<Display>> unmodifiableDisplays;
    private final Map<CategoryIdentifier<?>, List<DynamicDisplayGenerator<?>>> displayGenerators = new ConcurrentHashMap();
    private final List<DynamicDisplayGenerator<?>> globalDisplayGenerators = new ArrayList();
    private final List<DisplayVisibilityPredicate> visibilityPredicates = new ArrayList<DisplayVisibilityPredicate>();
    private final List<DisplayFiller<?>> fillers = new ArrayList();
    private final MutableInt displayCount = new MutableInt(0);
    private MutableLong lastAddWarning = new MutableLong(-1L);

    public DisplayRegistryImpl() {
        super(RecipeManagerContextImpl.supplier());
        this.unmodifiableDisplays = new RemappingMap<CategoryIdentifier, DisplaysList>(Collections.unmodifiableMap(this.displays), list -> {
            if (list == null) {
                return null;
            }
            return ((DisplaysList)list).unmodifiableList;
        }, key -> CategoryRegistry.getInstance().tryGet(key).isPresent());
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerDisplays(this);
    }

    @Override
    public int displaySize() {
        return this.displayCount.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Display display, @Nullable Object origin) {
        if (!PluginManager.areAnyReloading() && this.lastAddWarning != null) {
            if (this.lastAddWarning.getValue() > 0L && System.currentTimeMillis() - this.lastAddWarning.getValue() > 5000L) {
                InternalLogger.getInstance().warn("Detected runtime DisplayRegistry modification, this can be extremely dangerous!");
            }
            this.lastAddWarning.setValue(System.currentTimeMillis());
        }
        this.displays.computeIfAbsent(display.getCategoryIdentifier(), location -> new DisplaysList()).add(display);
        this.displayCount.increment();
        if (origin != null) {
            WeakHashMap<Display, Object> weakHashMap = this.displaysBase;
            synchronized (weakHashMap) {
                this.displaysBase.put(display, origin);
            }
        }
    }

    @Override
    public Map<CategoryIdentifier<?>, List<Display>> getAll() {
        return this.unmodifiableDisplays;
    }

    @Override
    public <A extends Display> void registerGlobalDisplayGenerator(DynamicDisplayGenerator<A> generator) {
        this.globalDisplayGenerators.add(generator);
        InternalLogger.getInstance().debug("Added global display generator: %s", generator);
    }

    @Override
    public <A extends Display> void registerDisplayGenerator(CategoryIdentifier<A> categoryId, DynamicDisplayGenerator<A> generator) {
        this.displayGenerators.computeIfAbsent(categoryId, location -> new ArrayList()).add(generator);
        InternalLogger.getInstance().debug("Added display generator for category [%s]: %s", categoryId, generator);
    }

    @Override
    public Map<CategoryIdentifier<?>, List<DynamicDisplayGenerator<?>>> getCategoryDisplayGenerators() {
        return Collections.unmodifiableMap(this.displayGenerators);
    }

    @Override
    public List<DynamicDisplayGenerator<?>> getGlobalDisplayGenerators() {
        return Collections.unmodifiableList(this.globalDisplayGenerators);
    }

    @Override
    public void registerVisibilityPredicate(DisplayVisibilityPredicate predicate) {
        this.visibilityPredicates.add(predicate);
        this.visibilityPredicates.sort(Comparator.reverseOrder());
        InternalLogger.getInstance().debug("Added display visibility predicate: %s [%.2f priority]", predicate, predicate.getPriority());
    }

    @Override
    public boolean isDisplayVisible(Display display) {
        DisplayCategory<?> category = CategoryRegistry.getInstance().get(display.getCategoryIdentifier()).getCategory();
        Preconditions.checkNotNull(category, (Object)("Failed to resolve category: " + display.getCategoryIdentifier()));
        for (DisplayVisibilityPredicate predicate : this.visibilityPredicates) {
            try {
                EventResult result = predicate.handleDisplay(category, display);
                if (!result.interruptsFurtherEvaluation()) continue;
                return result.isEmpty() || result.isTrue();
            }
            catch (Throwable throwable) {
                InternalLogger.getInstance().error("Failed to check if the display is visible!", throwable);
            }
        }
        return true;
    }

    @Override
    public List<DisplayVisibilityPredicate> getVisibilityPredicates() {
        return Collections.unmodifiableList(this.visibilityPredicates);
    }

    @Override
    public <T, D extends Display> void registerFiller(Class<T> typeClass, Predicate<? extends T> predicate, Function<? extends T, D> filler) {
        this.registerFiller((? o) -> typeClass.isInstance(o) && predicate.test(o), (? o) -> (Display)filler.apply(o));
    }

    @Override
    public <T, D extends Display> void registerFiller(Class<T> typeClass, BiPredicate<? extends T, DisplayAdditionReasons> predicate, Function<? extends T, D> filler) {
        this.fillers.add(new DisplayFiller<D>((o, s) -> typeClass.isInstance(o) && predicate.test((Object)o, (DisplayAdditionReasons)s), filler));
        InternalLogger.getInstance().debug("Added display filter: %s for %s", filler, typeClass.getName());
    }

    @Override
    public <D extends Display> void registerFiller(Predicate<?> predicate, Function<?, D> filler) {
        this.fillers.add(new DisplayFiller<D>((o, s) -> predicate.test(o), filler));
        InternalLogger.getInstance().debug("Added display filter: %s", filler);
    }

    @Override
    public void startReload() {
        super.startReload();
        this.displays.clear();
        this.displayGenerators.clear();
        this.visibilityPredicates.clear();
        this.fillers.clear();
        this.displayCount.setValue(0);
    }

    @Override
    public void endReload() {
        if (!this.fillers.isEmpty()) {
            List<Recipe<?>> allSortedRecipes = this.getAllSortedRecipes();
            for (int i = allSortedRecipes.size() - 1; i >= 0; --i) {
                Recipe<?> recipe = allSortedRecipes.get(i);
                this.addWithReason(recipe, DisplayAdditionReason.RECIPE_MANAGER);
            }
        }
        for (CategoryIdentifier<?> identifier : this.displays.keySet()) {
            if (!CategoryRegistry.getInstance().tryGet(identifier).isEmpty()) continue;
            InternalLogger.getInstance().error("Found displays registered for unknown registry", new IllegalStateException(identifier.toString()));
        }
        InternalLogger.getInstance().debug("Registered %d displays", this.displayCount.getValue());
    }

    @Override
    public <T> Collection<Display> tryFillDisplay(T value, DisplayAdditionReason ... reason) {
        if (value instanceof Display) {
            return Collections.singleton((Display)value);
        }
        List<?> displays = null;
        DisplayAdditionReasons.Impl reasons = reason.length == 0 ? DisplayAdditionReasons.Impl.EMPTY : new DisplayAdditionReasons.Impl(reason);
        for (DisplayFiller<?> filler : this.fillers) {
            Object display = this.tryFillDisplayGenerics(filler, value, reasons);
            if (display == null) continue;
            if (displays == null) {
                displays = Collections.singletonList(display);
                continue;
            }
            if (!(displays instanceof ArrayList)) {
                displays = new ArrayList(displays);
            }
            displays.add(display);
        }
        if (displays != null) {
            return displays;
        }
        return Collections.emptyList();
    }

    private <D extends Display> D tryFillDisplayGenerics(DisplayFiller<D> filler, Object value, DisplayAdditionReasons reasons) {
        try {
            if (filler.predicate.test(value, reasons)) {
                return (D)((Display)filler.mappingFunction.apply(value));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to fill displays!", e);
        }
        return null;
    }

    @Override
    @Nullable
    public Object getDisplayOrigin(Display display) {
        return this.displaysBase.get(display);
    }

    private static class RemappingMap<K, V>
    extends ForwardingMap<K, V> {
        protected final Map<K, V> map;
        protected final UnaryOperator<V> remapper;
        protected final Predicate<K> keyPredicate;

        public RemappingMap(Map<K, V> map, UnaryOperator<V> remapper, Predicate<K> keyPredicate) {
            this.map = map;
            this.remapper = remapper;
            this.keyPredicate = keyPredicate;
        }

        @NotNull
        protected Map<K, V> delegate() {
            return this.map;
        }

        public V get(Object key) {
            if (this.keyPredicate.test(key)) {
                return (V)this.remapper.apply(super.get(key));
            }
            return null;
        }

        public boolean containsKey(@Nullable Object key) {
            return super.containsKey(key) && this.keyPredicate.test(key);
        }

        public Set<K> keySet() {
            return Sets.filter((Set)super.keySet(), this.keyPredicate::test);
        }

        @NotNull
        public Set<Map.Entry<K, V>> entrySet() {
            return new ForwardingMap.StandardEntrySet(this){

                public Iterator<Map.Entry<K, V>> iterator() {
                    return this.mapIterator(map.entrySet().iterator());
                }
            };
        }

        public int size() {
            return this.keySet().size();
        }

        public Collection<V> values() {
            return new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return Iterators.transform(this.entrySet().iterator(), Map.Entry::getValue);
                }

                @Override
                public int size() {
                    return this.size();
                }
            };
        }

        private Iterator<Map.Entry<K, V>> mapIterator(Iterator<Map.Entry<K, V>> iterator) {
            return Iterators.transform((Iterator)Iterators.filter(iterator, entry -> this.keyPredicate.test(entry.getKey())), this::mapEntry);
        }

        private Map.Entry<K, V> mapEntry(final Map.Entry<K, V> entry) {
            return new ForwardingMapEntry<K, V>(){

                @NotNull
                protected Map.Entry<K, V> delegate() {
                    return entry;
                }

                public V getValue() {
                    return remapper.apply(entry.getValue());
                }
            };
        }
    }

    private static class DisplaysList
    extends ArrayList<Display> {
        private final List<Display> unmodifiableList;
        private final List<Display> synchronizedList = Collections.synchronizedList(this);

        public DisplaysList() {
            this.unmodifiableList = Collections.unmodifiableList(this.synchronizedList);
        }
    }

    private record DisplayFiller<D extends Display>(BiPredicate<Object, DisplayAdditionReasons> predicate, Function<Object, D> mappingFunction) {
    }
}

