/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntIntMutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.method.CharacterUnpackingInputMethod;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.search.IntRange;
import me.shedaniel.rei.impl.client.search.argument.AlternativeArgument;
import me.shedaniel.rei.impl.client.search.argument.CompoundArgument;
import me.shedaniel.rei.impl.client.search.argument.InputMethodMatcher;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentTypesRegistry;
import me.shedaniel.rei.impl.client.search.result.ArgumentApplicableResult;
import me.shedaniel.rei.impl.client.util.ThreadCreator;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class Argument<T, R> {
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadCreator("REI-ArgumentCache").asService();
    private static final Short2ObjectMap<Long2ObjectMap<Object>> SEARCH_CACHE = Short2ObjectMaps.synchronize((Short2ObjectMap)new Short2ObjectOpenHashMap());
    private static final Object NO_CACHE = new Object();
    private static final AtomicReference<String> lastLanguage = new AtomicReference();
    private ArgumentType<T, R> argumentType;
    private String text;
    private T filterData;
    private boolean regular;
    private final int start;
    private final int end;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?:\"([^\"]*)\")|([^\\s]+)");
    public static Long prepareStart = null;
    public static List<HashedEntryStackWrapper> prepareStacks = null;
    public static IntIntPair prepareStage = null;
    public static IntIntPair[] currentStages = null;

    public Argument(ArgumentType<T, R> argumentType, String text, boolean regular, int start, int end, boolean lowercase) {
        this.argumentType = argumentType;
        this.text = lowercase ? text.toLowerCase(Locale.ROOT) : text;
        this.regular = regular;
        this.filterData = null;
        this.start = start;
        this.end = end;
    }

    public static void resetCache(boolean cache) {
        SEARCH_CACHE.clear();
        if (cache) {
            Argument.prepareFilter(new AbstractCollection<EntryStack<?>>(){

                @Override
                public Iterator<EntryStack<?>> iterator() {
                    return Iterators.transform(EntryRegistry.getInstance().getPreFilteredList().iterator(), EntryStack::normalize);
                }

                @Override
                public int size() {
                    return EntryRegistry.getInstance().getPreFilteredList().size();
                }
            }, ArgumentTypesRegistry.ARGUMENT_TYPE_LIST, () -> true, EXECUTOR_SERVICE);
        }
    }

    public static boolean hasCache() {
        return !SEARCH_CACHE.isEmpty();
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public static List<CompoundArgument> bakeArguments(String filter) {
        return Argument.bakeArguments(filter, null);
    }

    public static List<CompoundArgument> bakeArguments(String filter, @Nullable ProcessedSink sink) {
        ArrayList compoundArguments = Lists.newArrayList();
        int tokenStartIndex = 0;
        for (String token : StringUtils.splitByWholeSeparatorPreserveAllTokens((String)filter, (String)"|")) {
            Matcher terms = SPLIT_PATTERN.matcher(token);
            CompoundArgument.Builder builder = CompoundArgument.builder();
            while (terms.find()) {
                AlternativeArgument.Builder alternativeBuilder = AlternativeArgument.builder();
                for (ArgumentType<?, ?> type : ArgumentTypesRegistry.ARGUMENT_TYPE_LIST) {
                    Argument.applyArgument(type, filter, terms, tokenStartIndex, alternativeBuilder, true, sink);
                    if (alternativeBuilder.isEmpty()) continue;
                    break;
                }
                if (alternativeBuilder.isEmpty()) {
                    for (ArgumentType<?, ?> type : ArgumentTypesRegistry.ARGUMENT_TYPE_LIST) {
                        Argument.applyArgument(type, filter, terms, tokenStartIndex, alternativeBuilder, false, sink);
                    }
                }
                builder.add(alternativeBuilder);
            }
            compoundArguments.add(builder.build());
            if (sink == null || (tokenStartIndex += 1 + token.length()) - 1 >= filter.length()) continue;
            sink.addSplitter(tokenStartIndex - 1);
        }
        Argument.prepareSearchFilter(compoundArguments);
        return compoundArguments;
    }

    private static void prepareSearchFilter(List<CompoundArgument> compoundArguments) {
        for (CompoundArgument arguments : compoundArguments) {
            Iterator iterator = arguments.iterator();
            while (iterator.hasNext()) {
                AlternativeArgument alternativeArgument = (AlternativeArgument)((Object)iterator.next());
                Iterator iterator2 = alternativeArgument.iterator();
                while (iterator2.hasNext()) {
                    Argument argument = (Argument)iterator2.next();
                    argument.filterData = argument.argumentType.prepareSearchFilter(argument.getText());
                }
            }
        }
    }

    private static void applyArgument(ArgumentType<?, ?> type, String filter, Matcher terms, int tokenStartIndex, AlternativeArgument.Builder alternativeBuilder, boolean forceGrammar, @Nullable ProcessedSink sink) {
        String term = (String)MoreObjects.firstNonNull((Object)terms.group(1), (Object)terms.group(2));
        if (type.getSearchMode() == SearchMode.NEVER) {
            return;
        }
        ArgumentApplicableResult result = type.checkApplicable(term, forceGrammar);
        if (result.isApplicable()) {
            int group = terms.group(1) != null ? 1 : 2;
            Argument argument = new Argument(type, result.getText(), !result.isInverted(), terms.start(group) + tokenStartIndex, terms.end(group) + tokenStartIndex, !result.shouldPreserveCasing());
            alternativeBuilder.add(argument);
            if (sink != null) {
                if (group == 1) {
                    sink.addQuote(terms.start() + tokenStartIndex);
                    if (terms.end() - 1 + tokenStartIndex < filter.length()) {
                        sink.addQuote(terms.end() - 1 + tokenStartIndex);
                    }
                }
                sink.addPart(argument, result.isUsingGrammar(), result.grammarRanges(), terms.start() + tokenStartIndex);
            }
        }
    }

    public static boolean matches(EntryStack<?> stack, List<CompoundArgument> compoundArguments, InputMethod<?> inputMethod) {
        if (compoundArguments.isEmpty()) {
            return true;
        }
        String newLanguage = Minecraft.m_91087_().f_91066_.f_92075_;
        if (!Objects.equals(lastLanguage.getAndSet(newLanguage), newLanguage)) {
            Argument.resetCache(false);
        }
        block0: for (CompoundArgument arguments : compoundArguments) {
            Iterator iterator = arguments.iterator();
            while (iterator.hasNext()) {
                AlternativeArgument argument = (AlternativeArgument)((Object)iterator.next());
                if (Argument.matches(stack, argument, inputMethod)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private static <T> boolean matches(EntryStack<?> stack, AlternativeArgument alternativeArgument, InputMethod<T> inputMethod) {
        if (alternativeArgument.isEmpty()) {
            return true;
        }
        long hashExact = EntryStacks.hashExact(stack);
        ResultSinkImpl<T> sink = new ResultSinkImpl<T>(inputMethod);
        Iterator iterator = alternativeArgument.iterator();
        while (iterator.hasNext()) {
            Argument argument = (Argument)iterator.next();
            sink.filters = inputMethod.expendFilter(argument.getText());
            if (Argument.matches(argument.getArgument(), stack, hashExact, argument.filterData, sink) != argument.isRegular()) continue;
            return true;
        }
        return false;
    }

    private static Long2ObjectMap<Object> getSearchCache(ArgumentType<?, ?> argumentType) {
        short argumentIndex = (short)argumentType.getIndex();
        Long2ObjectMap map = (Long2ObjectMap)SEARCH_CACHE.get(argumentIndex);
        if (map == null) {
            map = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
            SEARCH_CACHE.put(argumentIndex, (Object)map);
        }
        return map;
    }

    private static <T, R, B> boolean matches(ArgumentType<T, B> argumentType, EntryStack<?> stack, long hashExact, R filterData, ResultSinkImpl<?> sink) {
        Long2ObjectMap<Object> map = Argument.getSearchCache(argumentType);
        Object value = map.get(hashExact);
        if (value == null) {
            value = argumentType.cacheData(stack);
            map.put(hashExact, value == null ? NO_CACHE : value);
        }
        sink.matches = false;
        argumentType.matches(value == NO_CACHE ? null : value, stack, filterData, sink);
        return sink.matches;
    }

    public static void prepareFilter(Collection<EntryStack<?>> stacks, Collection<ArgumentType<?, ?>> argumentTypes) {
        Argument.prepareFilter(stacks, argumentTypes, () -> true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public static void prepareFilter(Collection<EntryStack<?>> stacks, Collection<ArgumentType<?, ?>> argumentTypes, BooleanSupplier isValid, @Nullable Executor executor) {
        block23: {
            if (prepareStage != null || currentStages != null) {
                return;
            }
            try {
                prepareStart = Util.m_137574_();
                Long2ObjectMap[] caches = (Long2ObjectMap[])CollectionUtils.map(argumentTypes, Argument::getSearchCache).toArray(Long2ObjectMap[]::new);
                prepareStacks = CollectionUtils.mapAndFilter(stacks, stack -> {
                    for (Long2ObjectMap cache : caches) {
                        if (cache.containsKey(stack.hashExact())) continue;
                        return true;
                    }
                    return false;
                }, HashedEntryStackWrapper::new);
                if (prepareStacks.isEmpty() && !isValid.getAsBoolean()) {
                    return;
                }
                InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Preparing " + prepareStacks.size() * argumentTypes.size() + " stacks for search arguments");
                prepareStage = new IntIntMutablePair(0, argumentTypes.size());
                currentStages = new IntIntPair[argumentTypes.size()];
                int searchPartitionSize = ConfigObject.getInstance().getAsyncSearchPartitionSize();
                boolean async = ConfigObject.getInstance().shouldAsyncSearch() && prepareStacks.size() > searchPartitionSize * 4;
                ArrayList futures = Lists.newArrayList();
                ArrayList pairs = Lists.newArrayList();
                for (ArgumentType<?, ?> argumentType : argumentTypes) {
                    prepareStage.first(prepareStage.firstInt() + 1);
                    Long2ObjectMap<Object> map = Argument.getSearchCache(argumentType);
                    IntIntMutablePair intIntMutablePair = new IntIntMutablePair(0, prepareStacks.size());
                    Argument.currentStages[Argument.prepareStage.firstInt() - 1] = intIntMutablePair;
                    IntIntMutablePair currentStage = intIntMutablePair;
                    if (!isValid.getAsBoolean()) {
                        return;
                    }
                    if (async) {
                        for (Collection partitionStacks : CollectionUtils.partition(prepareStacks, searchPartitionSize)) {
                            CompletionStage future = CompletableFuture.supplyAsync(() -> {
                                Long2ObjectArrayMap out = new Long2ObjectArrayMap(searchPartitionSize + 1);
                                int i = 0;
                                for (HashedEntryStackWrapper stack : partitionStacks) {
                                    Object data;
                                    if (map.get(stack.hashExact()) == null && (data = argumentType.cacheData(stack.unwrap())) != null) {
                                        out.put(stack.hashExact(), data);
                                    }
                                    if (i++ % 40 != 0 || isValid.getAsBoolean()) continue;
                                    return Long2ObjectMaps.emptyMap();
                                }
                                if (!isValid.getAsBoolean()) {
                                    return Long2ObjectMaps.emptyMap();
                                }
                                return out;
                            }, Objects.requireNonNullElse(executor, EXECUTOR_SERVICE)).whenComplete((arg_0, arg_1) -> Argument.lambda$prepareFilter$5((IntIntPair)currentStage, partitionStacks, arg_0, arg_1));
                            futures.add(future);
                            pairs.add(Pair.of(argumentType, (Object)future));
                        }
                        continue;
                    }
                    for (HashedEntryStackWrapper stack2 : prepareStacks) {
                        Object data;
                        currentStage.first(currentStage.firstInt() + 1);
                        if (map.get(stack2.hashExact()) != null || (data = argumentType.cacheData(stack2.unwrap())) == null) continue;
                        map.put(stack2.hashExact(), data);
                    }
                }
                if (async) {
                    Long2ObjectMap now;
                    int sum;
                    try {
                        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
                        sum = 0;
                    }
                    catch (ExecutionException | TimeoutException e) {
                        e.printStackTrace();
                        int sum5333332 = 0;
                        for (Pair pair : pairs) {
                            now = ((CompletableFuture)pair.second()).getNow(null);
                            if (now == null) continue;
                            Argument.getSearchCache((ArgumentType)pair.left()).putAll((Map)now);
                            sum5333332 += now.size();
                        }
                        InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Prepared " + sum5333332 + " / " + prepareStacks.size() * argumentTypes.size() + " stacks for search arguments in " + (Util.m_137574_() - prepareStart) + "ms");
                        break block23;
                    }
                    catch (InterruptedException sum5333332) {
                        int sum3 = 0;
                        for (Pair pair : pairs) {
                            now = ((CompletableFuture)pair.second()).getNow(null);
                            if (now == null) continue;
                            Argument.getSearchCache((ArgumentType)pair.left()).putAll((Map)now);
                            sum3 += now.size();
                        }
                        InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Prepared " + sum3 + " / " + prepareStacks.size() * argumentTypes.size() + " stacks for search arguments in " + (Util.m_137574_() - prepareStart) + "ms");
                        break block23;
                        {
                            catch (Throwable throwable) {
                                int sum4 = 0;
                                for (Pair pair : pairs) {
                                    Long2ObjectMap now2 = ((CompletableFuture)pair.second()).getNow(null);
                                    if (now2 == null) continue;
                                    Argument.getSearchCache((ArgumentType)pair.left()).putAll((Map)now2);
                                    sum4 += now2.size();
                                }
                                InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Prepared " + sum4 + " / " + prepareStacks.size() * argumentTypes.size() + " stacks for search arguments in " + (Util.m_137574_() - prepareStart) + "ms");
                                throw throwable;
                            }
                        }
                    }
                    for (Pair pair : pairs) {
                        now = ((CompletableFuture)pair.second()).getNow(null);
                        if (now == null) continue;
                        Argument.getSearchCache((ArgumentType)pair.left()).putAll((Map)now);
                        sum += now.size();
                    }
                    InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Prepared " + sum + " / " + prepareStacks.size() * argumentTypes.size() + " stacks for search arguments in " + (Util.m_137574_() - prepareStart) + "ms");
                    break block23;
                }
                InternalLogger.getInstance().log(ConfigObject.getInstance().doDebugSearchTimeRequired() ? Level.INFO : Level.TRACE, "Prepared " + prepareStacks.size() * argumentTypes.size() + " stacks for search arguments in " + (Util.m_137574_() - prepareStart) + "ms");
            }
            finally {
                prepareStart = null;
                prepareStacks = null;
                prepareStage = null;
                currentStages = null;
            }
        }
    }

    public ArgumentType<?, ?> getArgument() {
        return this.argumentType;
    }

    public String getText() {
        return this.text;
    }

    public boolean isRegular() {
        return this.regular;
    }

    public String toString() {
        return String.format("Argument[%s]: name = %s, regular = %b", this.argumentType.getName(), this.text, this.regular);
    }

    private static /* synthetic */ void lambda$prepareFilter$5(IntIntPair currentStage, Collection partitionStacks, Long2ObjectMap objectLong2ObjectMap, Throwable throwable) {
        currentStage.first(currentStage.firstInt() + partitionStacks.size());
    }

    public static interface ProcessedSink {
        public void addQuote(int var1);

        public void addSplitter(int var1);

        public void addPart(Argument<?, ?> var1, boolean var2, Collection<IntRange> var3, int var4);
    }

    private static class ResultSinkImpl<T>
    implements ArgumentType.ResultSink {
        private final InputMethod<T> inputMethod;
        private boolean matches;
        private Iterable<T> filters;

        public ResultSinkImpl(InputMethod<T> inputMethod) {
            this.inputMethod = inputMethod;
        }

        @Override
        public boolean testTrue() {
            this.matches = true;
            return true;
        }

        @Override
        public boolean testString(String text) {
            if (this.matches) {
                return true;
            }
            InputMethod<T> inputMethod = this.inputMethod;
            if (inputMethod instanceof CharacterUnpackingInputMethod) {
                CharacterUnpackingInputMethod im = (CharacterUnpackingInputMethod)inputMethod;
                for (T filter : this.filters) {
                    if (!InputMethodMatcher.contains(im, IntList.of((int[])text.codePoints().toArray()), (IntList)filter)) continue;
                    this.matches = true;
                    return true;
                }
            } else {
                for (T filter : this.filters) {
                    if (!this.inputMethod.contains(text, filter)) continue;
                    this.matches = true;
                    return true;
                }
            }
            return false;
        }
    }
}

