/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.test;

import com.google.common.collect.ImmutableList;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.TestOnly;

@OnlyIn(value=Dist.CLIENT)
@TestOnly
public class REITestPlugin
implements REIClientPlugin {
    private Random random = new Random();

    @Override
    public void preStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        InternalLogger.getInstance().error("REI Test Plugin is enabled! If you see this unintentionally, please report this!");
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        int times = 10;
        for (Item item : Registry.f_122827_) {
            EntryStack<ItemStack> base = EntryStacks.of((ItemLike)item);
            registry.addEntriesAfter(base, IntStream.range(0, times).mapToObj(value -> this.transformStack(EntryStacks.of((ItemLike)item))).collect(Collectors.toList()));
            try {
                for (ItemStack stack : registry.appendStacksForItem(item)) {
                    registry.addEntries(IntStream.range(0, times).mapToObj(value -> this.transformStack(EntryStacks.of(stack))).collect(Collectors.toList()));
                }
            }
            catch (Exception exception) {
            }
        }
    }

    @Override
    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        int i = 0;
        for (Item item : Registry.f_122827_) {
            if (i++ % 10 != 0) continue;
            registry.group(Registry.f_122827_.m_7981_((Object)item), (Component)new TextComponent(Registry.f_122827_.m_7981_((Object)item).toString()), stack -> stack.getType() == VanillaEntryTypes.ITEM && ((ItemStack)stack.castValue()).m_150930_(item));
        }
    }

    @Override
    public void registerItemComparators(ItemComparatorRegistry registry) {
        registry.registerNbt((Item[])Registry.f_122827_.m_123024_().toArray(Item[]::new));
    }

    public EntryStack<ItemStack> transformStack(EntryStack<ItemStack> stack) {
        CompoundTag tag = stack.getValue().m_41784_();
        tag.m_128405_("Whatever", this.random.nextInt(Integer.MAX_VALUE));
        return stack;
    }

    @Override
    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.registerSystemFavorites(() -> {
            GameType mode = Minecraft.m_91087_().f_91072_.m_105295_();
            switch (mode) {
                case SURVIVAL: {
                    return ImmutableList.of((Object)FavoriteEntry.fromEntryStack(EntryStacks.of((ItemLike)Items.f_41905_)));
                }
                case CREATIVE: {
                    return ImmutableList.of((Object)FavoriteEntry.fromEntryStack(EntryStacks.of((ItemLike)Items.f_42201_)));
                }
                case ADVENTURE: {
                    return ImmutableList.of((Object)FavoriteEntry.fromEntryStack(EntryStacks.of((ItemLike)Items.f_42146_)));
                }
            }
            return ImmutableList.of();
        });
    }
}

