/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mehvahdjukaar.modelfix;

import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.core.Direction;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ModelFix {
    public static final String MOD_ID = "modelfix";
    private static boolean FORGE = true;

    public static float getShrinkRatio() {
        return 0.0f;
    }

    public static float getRecess() {
        return FORGE ? 0.006f : 0.01f;
    }

    public static float getExpansion() {
        return FORGE ? 0.006f : 0.0f;
    }

    public static void createOrExpandSpan(List<ItemModelGenerator.Span> listSpans, ItemModelGenerator.SpanFacing spanFacing, int pixelX, int pixelY) {
        int length;
        ItemModelGenerator.Span existingSpan = null;
        for (ItemModelGenerator.Span span2 : listSpans) {
            int i;
            if (span2.m_111683_() != spanFacing) continue;
            int n = i = spanFacing.m_111709_() ? pixelY : pixelX;
            if (span2.m_111688_() != i || FORGE && span2.m_111687_() != (!spanFacing.m_111709_() ? pixelY : pixelX) - 1) continue;
            existingSpan = span2;
            break;
        }
        int n = length = spanFacing.m_111709_() ? pixelX : pixelY;
        if (existingSpan == null) {
            int newStart = spanFacing.m_111709_() ? pixelY : pixelX;
            listSpans.add(new ItemModelGenerator.Span(spanFacing, length, newStart));
        } else {
            existingSpan.m_111684_(length);
        }
    }

    public static void enlargeFaces(CallbackInfoReturnable<List<BlockElement>> cir) {
        float inc = ModelFix.getRecess();
        float inc2 = ModelFix.getExpansion();
        for (BlockElement e : (List)cir.getReturnValue()) {
            Vector3f from = e.f_111308_;
            Vector3f to = e.f_111309_;
            Set set = e.f_111310_.keySet();
            if (set.size() != 1) continue;
            Direction dir = (Direction)set.stream().findAny().get();
            switch (dir) {
                case UP: {
                    from.m_122245_(from.m_122239_() - inc2, from.m_122260_() - inc, from.m_122269_() - inc2);
                    to.m_122245_(to.m_122239_() + inc2, to.m_122260_() - inc, to.m_122269_() + inc2);
                    break;
                }
                case DOWN: {
                    from.m_122245_(from.m_122239_() - inc2, from.m_122260_() + inc, from.m_122269_() - inc2);
                    to.m_122245_(to.m_122239_() + inc2, to.m_122260_() + inc, to.m_122269_() + inc2);
                    break;
                }
                case WEST: {
                    from.m_122245_(from.m_122239_() - inc, from.m_122260_() + inc2, from.m_122269_() - inc2);
                    to.m_122245_(to.m_122239_() - inc, to.m_122260_() - inc2, to.m_122269_() + inc2);
                    break;
                }
                case EAST: {
                    from.m_122245_(from.m_122239_() + inc, from.m_122260_() + inc2, from.m_122269_() - inc2);
                    to.m_122245_(to.m_122239_() + inc, to.m_122260_() - inc2, to.m_122269_() + inc2);
                }
            }
        }
    }
}

