/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas;

import dev.architectury.event.events.common.LifecycleEvent;
import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.core.AtlasIdData;
import hunternif.mc.impl.atlas.core.GlobalTileDataHandler;
import hunternif.mc.impl.atlas.core.PlayerEventHandler;
import hunternif.mc.impl.atlas.core.TileDataHandler;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorBase;
import hunternif.mc.impl.atlas.core.scaning.WorldScanner;
import hunternif.mc.impl.atlas.event.RecipeCraftedCallback;
import hunternif.mc.impl.atlas.event.RecipeCraftedHandler;
import hunternif.mc.impl.atlas.item.AntiqueAtlasItems;
import hunternif.mc.impl.atlas.marker.GlobalMarkersDataHandler;
import hunternif.mc.impl.atlas.marker.MarkersDataHandler;
import hunternif.mc.impl.atlas.mixinhooks.NewPlayerConnectionCallback;
import hunternif.mc.impl.atlas.mixinhooks.NewServerConnectionCallback;
import hunternif.mc.impl.atlas.network.AntiqueAtlasNetworking;
import hunternif.mc.impl.atlas.structure.EndCity;
import hunternif.mc.impl.atlas.structure.NetherFortress;
import hunternif.mc.impl.atlas.structure.Overworld;
import hunternif.mc.impl.atlas.structure.StructureAddedCallback;
import hunternif.mc.impl.atlas.structure.StructureHandler;
import hunternif.mc.impl.atlas.structure.StructurePieceAddedCallback;
import hunternif.mc.impl.atlas.structure.Village;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AntiqueAtlasMod {
    public static final String ID = "antiqueatlas";
    public static final String NAME = "Antique Atlas";
    public static Logger LOG = LogManager.getLogger((String)"Antique Atlas");
    public static final WorldScanner worldScanner = new WorldScanner();
    public static final TileDataHandler tileData = new TileDataHandler();
    public static final MarkersDataHandler markersData = new MarkersDataHandler();
    public static final GlobalTileDataHandler globalTileData = new GlobalTileDataHandler();
    public static final GlobalMarkersDataHandler globalMarkersData = new GlobalMarkersDataHandler();
    public static AntiqueAtlasConfig CONFIG = new AntiqueAtlasConfig();

    public static ResourceLocation id(String ... path) {
        return path[0].contains(":") ? new ResourceLocation(String.join((CharSequence)".", path)) : new ResourceLocation(ID, String.join((CharSequence)".", path));
    }

    public static AtlasIdData getAtlasIdData(Level world) {
        if (world.m_5776_()) {
            LOG.warn("Tried to access server only data from client.");
            return null;
        }
        return (AtlasIdData)((ServerLevel)world).m_8895_().m_164861_(AtlasIdData::fromNbt, AtlasIdData::new, "antiqueatlas:global_atlas_data");
    }

    public static void init() {
        TileDetectorBase.scanBiomeTypes();
        AutoConfig.register(AntiqueAtlasConfig.class, JanksonConfigSerializer::new);
        CONFIG = (AntiqueAtlasConfig)AutoConfig.getConfigHolder(AntiqueAtlasConfig.class).getConfig();
        AntiqueAtlasItems.register();
        AntiqueAtlasNetworking.registerC2SListeners();
        NewServerConnectionCallback.EVENT.register(tileData::onClientConnectedToServer);
        NewServerConnectionCallback.EVENT.register(markersData::onClientConnectedToServer);
        NewServerConnectionCallback.EVENT.register(globalMarkersData::onClientConnectedToServer);
        NewPlayerConnectionCallback.EVENT.register(globalMarkersData::onPlayerLogin);
        NewPlayerConnectionCallback.EVENT.register(globalTileData::onPlayerLogin);
        NewPlayerConnectionCallback.EVENT.register(PlayerEventHandler::onPlayerLogin);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(globalMarkersData::onWorldLoad);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(globalTileData::onWorldLoad);
        RecipeCraftedCallback.EVENT.register((Object)new RecipeCraftedHandler());
        StructurePieceAddedCallback.EVENT.register(StructureHandler::resolve);
        StructureAddedCallback.EVENT.register(StructureHandler::resolve);
        NetherFortress.registerPieces();
        EndCity.registerMarkers();
        Village.registerMarkers();
        Village.registerPieces();
        Overworld.registerPieces();
    }
}

