/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.IResourceReloadListener;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.client.texture.TileTexture;
import hunternif.mc.impl.atlas.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureConfig
implements IResourceReloadListener<Map<ResourceLocation, ITexture>> {
    private final Map<ResourceLocation, ITexture> texture_map;

    public TextureConfig(Map<ResourceLocation, ITexture> texture_map) {
        this.texture_map = texture_map;
    }

    @Override
    public CompletableFuture<Map<ResourceLocation, ITexture>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, TileTexture> textures = new HashMap<ResourceLocation, TileTexture>();
            for (ResourceLocation id : manager.m_6540_("textures/gui/tiles", s -> s.endsWith(".png"))) {
                try {
                    ResourceLocation texture_id = new ResourceLocation(id.m_135827_(), id.m_135815_().replace("textures/gui/tiles/", "").replace(".png", ""));
                    textures.put(texture_id, new TileTexture(id));
                }
                catch (ResourceLocationException e) {
                    AntiqueAtlasMod.LOG.warn("Failed to read texture!", (Throwable)e);
                }
            }
            return textures;
        });
    }

    @Override
    public CompletableFuture<Void> apply(Map<ResourceLocation, ITexture> textures, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            this.texture_map.clear();
            for (Map.Entry entry : textures.entrySet()) {
                this.texture_map.put((ResourceLocation)entry.getKey(), (ITexture)entry.getValue());
                Log.info("Loaded texture %s with path %s", entry.getKey(), ((ITexture)entry.getValue()).getTexture());
            }
        });
    }

    public String m_7812_() {
        return AntiqueAtlasMod.id("textures").toString();
    }
}

