/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.IResourceReloadListener;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MarkerTextureConfig
implements IResourceReloadListener<Map<ResourceLocation, MarkerType>> {
    private static final int VERSION = 1;
    private static final JsonParser parser = new JsonParser();

    @Override
    public CompletableFuture<Map<ResourceLocation, MarkerType>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, MarkerType> typeMap = new HashMap<ResourceLocation, MarkerType>();
            for (ResourceLocation id : manager.m_6540_("atlas/markers", s -> s.endsWith(".json"))) {
                ResourceLocation markerId = new ResourceLocation(id.m_135827_(), id.m_135815_().replace("atlas/markers/", "").replace(".json", ""));
                try {
                    Resource resource = manager.m_142591_(id);
                    InputStream stream = resource.m_6679_();
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = parser.parse((Reader)reader).getAsJsonObject();
                        int version = object.getAsJsonPrimitive("version").getAsInt();
                        if (version != 1) {
                            throw new RuntimeException("Incompatible version (1 != " + version + ")");
                        }
                        MarkerType markerType = new MarkerType(markerId);
                        markerType.getJSONData().readFrom(object);
                        markerType.setIsFromJson(true);
                        typeMap.put(markerId, markerType);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    AntiqueAtlasMod.LOG.warn("Error reading marker " + markerId + "!", (Throwable)e);
                }
            }
            return typeMap;
        });
    }

    @Override
    public CompletableFuture<Void> apply(Map<ResourceLocation, MarkerType> data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : data.entrySet()) {
                MarkerType.register((ResourceLocation)entry.getKey(), (MarkerType)entry.getValue());
            }
        });
    }

    public String m_7812_() {
        return AntiqueAtlasMod.id("markers").toString();
    }
}

