/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.network.packet.s2c.play.PutMarkersS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class MarkersData
extends SavedData {
    private static final int VERSION = 4;
    private static final String TAG_VERSION = "aaVersion";
    private static final String TAG_WORLD_MAP_LIST = "worldMap";
    private static final String TAG_WORLD_ID = "worldID";
    private static final String TAG_MARKERS = "markers";
    private static final String TAG_MARKER_ID = "id";
    private static final String TAG_MARKER_TYPE = "markerType";
    private static final String TAG_MARKER_LABEL = "label";
    private static final String TAG_MARKER_X = "x";
    private static final String TAG_MARKER_Y = "y";
    private static final String TAG_MARKER_VISIBLE_AHEAD = "visAh";
    public static final int CHUNK_STEP = 8;
    private final Set<Player> playersSentTo = new HashSet<Player>();
    private final AtomicInteger largestID = new AtomicInteger(0);
    private final Map<Integer, Marker> idMap = new ConcurrentHashMap<Integer, Marker>(2, 0.75f, 2);
    private final Map<ResourceKey<Level>, DimensionMarkersData> worldMap = new ConcurrentHashMap<ResourceKey<Level>, DimensionMarkersData>(2, 0.75f, 2);

    private int getNewID() {
        return this.largestID.incrementAndGet();
    }

    public static MarkersData fromNbt(CompoundTag compound) {
        MarkersData data = new MarkersData();
        MarkersData.doReadNbt(compound, data);
        return data;
    }

    protected static void doReadNbt(CompoundTag compound, MarkersData data) {
        int version = compound.m_128451_(TAG_VERSION);
        if (version < 4) {
            Log.warn("Outdated atlas data format! Was %d but current is %d", version, 4);
            return;
        }
        ListTag dimensionMapList = compound.m_128437_(TAG_WORLD_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.size(); ++d) {
            CompoundTag tag = dimensionMapList.m_128728_(d);
            ResourceKey world = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_(TAG_WORLD_ID)));
            ListTag tagList = tag.m_128437_(TAG_MARKERS, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag markerTag = tagList.m_128728_(i);
                boolean visibleAhead = markerTag.m_128471_(TAG_MARKER_VISIBLE_AHEAD);
                int id = markerTag.m_128451_(TAG_MARKER_ID);
                if (data.getMarkerByID(id) != null) {
                    Log.warn("Loading marker with duplicate id %d. Getting new id", id);
                    id = data.getNewID();
                }
                data.m_77762_();
                if (data.largestID.intValue() < id) {
                    data.largestID.set(id);
                }
                Marker marker = new Marker(id, new ResourceLocation(markerTag.m_128461_(TAG_MARKER_TYPE)), (Component)Component.Serializer.m_130701_((String)markerTag.m_128461_(TAG_MARKER_LABEL)), (ResourceKey<Level>)world, markerTag.m_128451_(TAG_MARKER_X), markerTag.m_128451_(TAG_MARKER_Y), visibleAhead);
                data.loadMarker(marker);
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        Log.info("Saving local markers data to NBT", new Object[0]);
        compound.m_128405_(TAG_VERSION, 4);
        ListTag dimensionMapList = new ListTag();
        for (ResourceKey<Level> world : this.worldMap.keySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(TAG_WORLD_ID, world.m_135782_().toString());
            DimensionMarkersData data = this.getMarkersDataInWorld(world);
            ListTag tagList = new ListTag();
            for (Marker marker : data.getAllMarkers()) {
                CompoundTag markerTag = new CompoundTag();
                markerTag.m_128405_(TAG_MARKER_ID, marker.getId());
                markerTag.m_128359_(TAG_MARKER_TYPE, marker.getType().toString());
                markerTag.m_128359_(TAG_MARKER_LABEL, Component.Serializer.m_130703_((Component)marker.getLabel()));
                markerTag.m_128405_(TAG_MARKER_X, marker.getX());
                markerTag.m_128405_(TAG_MARKER_Y, marker.getZ());
                markerTag.m_128379_(TAG_MARKER_VISIBLE_AHEAD, marker.isVisibleAhead());
                tagList.add((Object)markerTag);
            }
            tag.m_128365_(TAG_MARKERS, (Tag)tagList);
            dimensionMapList.add((Object)tag);
        }
        compound.m_128365_(TAG_WORLD_MAP_LIST, (Tag)dimensionMapList);
        return compound;
    }

    public Set<ResourceKey<Level>> getVisitedDimensions() {
        return this.worldMap.keySet();
    }

    public Collection<Marker> getMarkersInWorld(ResourceKey<Level> world) {
        return this.getMarkersDataInWorld(world).getAllMarkers();
    }

    public DimensionMarkersData getMarkersDataInWorld(ResourceKey<Level> world) {
        return this.worldMap.computeIfAbsent(world, k -> new DimensionMarkersData(this, world));
    }

    public List<Marker> getMarkersAtChunk(ResourceKey<Level> world, int x, int z) {
        return this.getMarkersDataInWorld(world).getMarkersAtChunk(x, z);
    }

    private Marker getMarkerByID(int id) {
        return this.idMap.get(id);
    }

    public Marker removeMarker(int id) {
        Marker marker = this.getMarkerByID(id);
        if (marker == null) {
            return null;
        }
        if (this.idMap.remove(id) != null) {
            this.getMarkersDataInWorld(marker.getWorld()).removeMarker(marker);
            this.m_77762_();
        }
        return marker;
    }

    public Marker createAndSaveMarker(ResourceLocation type, ResourceKey<Level> world, int x, int z, boolean visibleAhead, Component label) {
        Marker marker = new Marker(this.getNewID(), type, label, world, x, z, visibleAhead);
        Log.info("Created new marker %s", marker.toString());
        this.idMap.put(marker.getId(), marker);
        this.getMarkersDataInWorld(world).insertMarker(marker);
        this.m_77762_();
        return marker;
    }

    public Marker loadMarker(Marker marker) {
        if (!this.idMap.containsKey(marker.getId())) {
            this.idMap.put(marker.getId(), marker);
            int totalMarkers = 0;
            for (Map.Entry<ResourceKey<Level>, DimensionMarkersData> e : this.worldMap.entrySet()) {
                totalMarkers += e.getValue().getAllMarkers().size();
            }
            if (totalMarkers < AntiqueAtlasMod.CONFIG.markerLimit) {
                this.getMarkersDataInWorld(marker.getWorld()).insertMarker(marker);
            } else {
                Log.warn("Could not add new marker. Atlas is at it's limit of %d markers", AntiqueAtlasMod.CONFIG.markerLimit);
            }
        }
        return marker;
    }

    public boolean isSyncedOnPlayer(Player player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, ServerPlayer player) {
        for (ResourceKey<Level> world : this.worldMap.keySet()) {
            DimensionMarkersData data = this.getMarkersDataInWorld(world);
            new PutMarkersS2CPacket(atlasID, world, data.getAllMarkers()).send(player);
        }
        Log.info("Sent markers data #%d to player %s", atlasID, player.m_20203_().m_81368_());
        this.playersSentTo.add((Player)player);
    }

    public boolean isEmpty() {
        return this.idMap.isEmpty();
    }
}

