/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.MarkersData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class MarkersDataHandler {
    private static final String MARKERS_DATA_PREFIX = "aaMarkers_";
    private final Map<String, MarkersData> markersDataClientCache = new ConcurrentHashMap<String, MarkersData>();

    public MarkersData getMarkersData(ItemStack stack, Level world) {
        if (stack.m_41720_() instanceof AtlasItem) {
            return this.getMarkersData(AtlasItem.getAtlasID(stack), world);
        }
        return null;
    }

    public MarkersData getMarkersData(int atlasID, Level world) {
        String key = this.getMarkersDataKey(atlasID);
        if (world.f_46443_) {
            return this.markersDataClientCache.computeIfAbsent(key, s -> new MarkersData());
        }
        DimensionDataStorage manager = ((ServerLevel)world).m_8895_();
        return (MarkersData)manager.m_164861_(MarkersData::fromNbt, () -> new MarkersData(), key);
    }

    private String getMarkersDataKey(int atlasID) {
        return MARKERS_DATA_PREFIX + atlasID;
    }

    public void onClientConnectedToServer(boolean isRemote) {
        this.markersDataClientCache.clear();
    }
}

