/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import dev.architectury.networking.NetworkManager;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileInfo;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DimensionUpdateS2CPacket
extends S2CPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "s2c", "dimension", "update");

    public DimensionUpdateS2CPacket(int atlasID, ResourceKey<Level> world, Collection<TileInfo> tiles) {
        this.m_130130_(atlasID);
        this.m_130085_(world.m_135782_());
        this.m_130130_(tiles.size());
        for (TileInfo tile : tiles) {
            this.m_130130_(tile.x);
            this.m_130130_(tile.z);
            this.m_130085_(tile.id);
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public static void apply(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int atlasID = buf.m_130242_();
        ResourceKey world = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        int tileCount = buf.m_130242_();
        if (world == null) {
            return;
        }
        ArrayList<TileInfo> tiles = new ArrayList<TileInfo>();
        for (int i = 0; i < tileCount; ++i) {
            tiles.add(new TileInfo(buf.m_130242_(), buf.m_130242_(), buf.m_130281_()));
        }
        context.queue(() -> {
            Player player = context.getPlayer();
            assert (player != null);
            AtlasData data = AntiqueAtlasMod.tileData.getData(atlasID, player.m_20193_());
            for (TileInfo info : tiles) {
                data.getWorldData((ResourceKey<Level>)world).setTile(info.x, info.z, info.id);
            }
        });
    }
}

