/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.dsurround.huds.lightlevel;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import dynamiclabs.immersivefx.dsurround.DynamicSurroundings;
import dynamiclabs.immersivefx.dsurround.config.Config;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.TickCounter;
import dynamiclabs.immersivefx.lib.collections.ObjectArray;
import dynamiclabs.immersivefx.lib.gui.Color;
import dynamiclabs.immersivefx.lib.gui.ColorPalette;
import dynamiclabs.immersivefx.lib.math.MathStuff;
import dynamiclabs.immersivefx.lib.particles.FrustumHelper;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LightLevelHUD {
    private static Font font;
    private static boolean showHUD;
    private static final int ALLOCATION_SIZE = 2048;
    private static final ObjectArray<LightCoord> lightLevels;
    private static final BlockPos.MutableBlockPos mutable;
    private static int nextCoord;
    private static final String[] lightLevelText;
    private static final int[] margins;

    private static LightCoord nextCoord() {
        if (nextCoord == lightLevels.size()) {
            lightLevels.add(new LightCoord());
        }
        return lightLevels.get(nextCoord++);
    }

    protected static boolean inFrustum(double x, double y, double z) {
        return FrustumHelper.isLocationInFrustum(new Vec3(x, y, z));
    }

    protected static boolean renderLightLevel(@Nonnull BlockState state, @Nonnull BlockState below) {
        Material stateMaterial = state.m_60767_();
        Material belowMaterial = below.m_60767_();
        return !stateMaterial.m_76333_() && !stateMaterial.m_76332_() && belowMaterial.m_76333_();
    }

    protected static float heightAdjustment(@Nonnull BlockState state, @Nonnull BlockState below, @Nonnull BlockPos pos) {
        if (state.m_60767_() == Material.f_76296_) {
            VoxelShape shape = below.m_60812_((BlockGetter)GameUtils.getWorld(), pos.m_7495_());
            return shape.m_83281_() ? 0.0f : (float)shape.m_83297_(Direction.Axis.Y) - 1.0f;
        }
        VoxelShape shape = below.m_60812_((BlockGetter)GameUtils.getWorld(), pos);
        if (shape.m_83281_()) {
            return 0.0f;
        }
        float adjust = (float)shape.m_83297_(Direction.Axis.Y);
        return state.m_60734_() == Blocks.f_50125_ ? adjust + 0.125f : adjust;
    }

    protected static void updateLightInfo(@Nonnull Vec3 position) {
        Font fr = GameUtils.getMC().f_91062_;
        if (fr != font) {
            font = fr;
            for (int i = 0; i < 16; ++i) {
                LightLevelHUD.margins[i] = -(font.m_92895_(lightLevelText[i]) + 1) / 2;
            }
        }
        nextCoord = 0;
        ColorSet colors = (ColorSet)((Object)Config.CLIENT.lightLevel.colorSet.get());
        Mode displayMode = (Mode)((Object)Config.CLIENT.lightLevel.mode.get());
        int skyLightSub = GameUtils.getWorld().m_7445_();
        int rangeXZ = (Integer)Config.CLIENT.lightLevel.range.get() * 2 + 1;
        int rangeY = (Integer)Config.CLIENT.lightLevel.range.get() + 1;
        int originX = MathStuff.floor(position.f_82479_) - rangeXZ / 2;
        int originZ = MathStuff.floor(position.f_82481_) - rangeXZ / 2;
        int originY = MathStuff.floor(position.f_82480_) - (rangeY - 3);
        ClientLevel world = GameUtils.getWorld();
        for (int dX = 0; dX < rangeXZ; ++dX) {
            for (int dZ = 0; dZ < rangeXZ; ++dZ) {
                int trueX = originX + dX;
                int trueZ = originZ + dZ;
                BlockState lastState = null;
                for (int dY = 0; dY < rangeY; ++dY) {
                    int trueY = originY + dY;
                    if (trueY < 1 || !LightLevelHUD.inFrustum(trueX, trueY, trueZ)) continue;
                    BlockPos pos = new BlockPos(trueX, trueY, trueZ);
                    BlockState state = world.m_8055_(pos);
                    if (lastState == null) {
                        lastState = world.m_8055_(pos.m_7495_());
                    }
                    if (LightLevelHUD.renderLightLevel(state, lastState)) {
                        mutable.m_122178_(trueX, trueY, trueZ);
                        boolean mobSpawn = lastState.isValidSpawn((LevelReader)GameUtils.getWorld(), (BlockPos)mutable, SpawnPlacements.Type.ON_GROUND, EntityType.f_20501_);
                        if (mobSpawn || !((Boolean)Config.CLIENT.lightLevel.hideSafe.get()).booleanValue()) {
                            int blockLight = world.m_45517_(LightLayer.BLOCK, (BlockPos)mutable);
                            int skyLight = world.m_45517_(LightLayer.SKY, (BlockPos)mutable) - skyLightSub;
                            int effective = Math.max(blockLight, skyLight);
                            int result = displayMode == Mode.BLOCK_SKY ? effective : (displayMode == Mode.BLOCK ? blockLight : skyLight);
                            Color color = colors.safe;
                            if (!mobSpawn) {
                                color = colors.noSpawn;
                            } else if (blockLight <= (Integer)Config.CLIENT.lightLevel.lightSpawnThreshold.get()) {
                                color = effective > (Integer)Config.CLIENT.lightLevel.lightSpawnThreshold.get() ? colors.caution : colors.hazard;
                            }
                            if (color != colors.safe || !((Boolean)Config.CLIENT.lightLevel.hideSafe.get()).booleanValue()) {
                                LightCoord coord = LightLevelHUD.nextCoord();
                                coord.x = trueX;
                                coord.y = (double)((float)trueY + LightLevelHUD.heightAdjustment(state, lastState, (BlockPos)mutable)) + 0.002;
                                coord.z = trueZ;
                                coord.lightLevel = result;
                                coord.color = color.rgbWithAlpha(254);
                            }
                        }
                    }
                    lastState = state;
                }
            }
        }
    }

    public static void toggleDisplay() {
        showHUD = !showHUD;
        DynamicSurroundings.LOGGER.info("Light Level HUD: %s", Boolean.toString(showHUD));
    }

    @SubscribeEvent
    public static void doTick(@Nonnull TickEvent.PlayerTickEvent event) {
        if (!showHUD || event.side == LogicalSide.SERVER || event.phase == TickEvent.Phase.END || GameUtils.getMC().m_91104_()) {
            return;
        }
        if (event.player == null || event.player.f_19853_ == null) {
            return;
        }
        if (TickCounter.getTickCount() % 4L != 0L) {
            return;
        }
        LightLevelHUD.updateLightInfo(event.player.m_20182_());
    }

    public static void render(@Nonnull PoseStack matrixStack, float partialTicks) {
        if (!showHUD || nextCoord == 0) {
            return;
        }
        Player player = GameUtils.getPlayer();
        if (player == null) {
            return;
        }
        LightLevelHUD.drawStringRender(matrixStack, player);
    }

    private static void drawStringRender(@Nonnull PoseStack matrixStack, @Nonnull Player player) {
        boolean thirdPerson = GameUtils.isThirdPersonView();
        Direction playerFacing = player.m_6350_();
        if (thirdPerson) {
            playerFacing = playerFacing.m_122424_();
        }
        if (playerFacing == Direction.SOUTH || playerFacing == Direction.NORTH) {
            playerFacing = playerFacing.m_122424_();
        }
        float rotationAngle = playerFacing.m_122424_().m_122435_();
        Quaternion rotY = Vector3f.f_122225_.m_122240_(rotationAngle);
        Quaternion rotX = Vector3f.f_122223_.m_122240_(90.0f);
        Vec3 view = GameUtils.getMC().f_91063_.m_109153_().m_90583_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69458_((boolean)true);
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Objects.requireNonNull(font);
        int yAdjust = -(9 / 2);
        for (int i = 0; i < nextCoord; ++i) {
            LightCoord coord = lightLevels.get(i);
            String text = lightLevelText[coord.lightLevel];
            int margin = margins[coord.lightLevel];
            float scale = 0.07f;
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)coord.x + 0.5, coord.y, (double)coord.z + 0.5);
            matrixStack.m_85845_(rotY);
            matrixStack.m_85845_(rotX);
            matrixStack.m_85841_(-0.07f, -0.07f, 0.07f);
            font.m_92811_(text, (float)margin, (float)yAdjust, coord.color, false, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, 0xF000F0);
            matrixStack.m_85849_();
        }
        buffer.m_109911_();
        matrixStack.m_85849_();
    }

    static {
        int i;
        showHUD = false;
        lightLevels = new ObjectArray(2048);
        mutable = new BlockPos.MutableBlockPos();
        nextCoord = 0;
        lightLevelText = new String[16];
        margins = new int[16];
        for (i = 0; i < 2048; ++i) {
            lightLevels.add(new LightCoord());
        }
        for (i = 0; i < 16; ++i) {
            LightLevelHUD.lightLevelText[i] = String.valueOf(i);
        }
    }

    private static final class LightCoord {
        public int x;
        public double y;
        public int z;
        public int lightLevel;
        public int color;

        private LightCoord() {
        }
    }

    public static enum ColorSet {
        BRIGHT(ColorPalette.MC_GREEN, ColorPalette.MC_YELLOW, ColorPalette.MC_RED, ColorPalette.MC_DARKAQUA),
        DARK(ColorPalette.MC_DARKGREEN, ColorPalette.MC_GOLD, ColorPalette.MC_DARKRED, ColorPalette.MC_DARKBLUE);

        public final Color safe;
        public final Color caution;
        public final Color hazard;
        public final Color noSpawn;

        private ColorSet(@Nonnull Color safe, @Nonnull Color caution, Color hazard, Color noSpawn) {
            this.safe = safe;
            this.caution = caution;
            this.hazard = hazard;
            this.noSpawn = noSpawn;
        }
    }

    public static enum Mode {
        BLOCK,
        SKY,
        BLOCK_SKY;

    }
}

