/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.effects;

import dynamiclabs.immersivefx.environs.effects.BlockEffectType;
import dynamiclabs.immersivefx.environs.effects.JetEffect;
import dynamiclabs.immersivefx.environs.effects.emitters.SteamJet;
import dynamiclabs.immersivefx.lib.WorldUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SteamJetEffect
extends JetEffect {
    public SteamJetEffect(int chance) {
        super(chance);
    }

    public static boolean isValidSpawnBlock(@Nonnull BlockGetter provider, @Nonnull BlockPos pos, @Nonnull BlockState source) {
        if (!WorldUtils.isAirBlock(provider, pos.m_7494_())) {
            return false;
        }
        if (provider.m_8055_(pos) != source) {
            return false;
        }
        return SteamJetEffect.countCubeBlocks(provider, pos, HOTBLOCK_PREDICATE, true) > 0;
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.STEAM;
    }

    @Override
    public boolean canTrigger(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return SteamJetEffect.isValidSpawnBlock(provider, pos, state) && super.canTrigger(provider, state, pos, random);
    }

    @Override
    public void doEffect(@Nonnull BlockGetter provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int strength = SteamJetEffect.countCubeBlocks(provider, pos, HOTBLOCK_PREDICATE, false);
        if (strength > 0) {
            FluidState fluidState = state.m_60819_();
            float spawnHeight = fluidState.m_76178_() ? (float)pos.m_123342_() + 0.9f : (float)pos.m_123342_() + fluidState.m_76182_() + 0.1f;
            SteamJet effect = new SteamJet(strength, provider, (double)pos.m_123341_() + 0.5, spawnHeight, (double)pos.m_123343_() + 0.5);
            this.addEffect(effect);
        }
    }
}

