/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.effects.emitters;

import dynamiclabs.immersivefx.environs.effects.emitters.ParticleEmitter;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class Jet
extends ParticleEmitter {
    protected final int jetStrength;
    protected final int updateFrequency;
    protected final int particleMaxAge;
    protected int particleAge;

    public Jet(int strength, BlockGetter world, double x, double y, double z) {
        this(0, strength, world, x, y, z, 3);
    }

    public Jet(int layer, int strength, BlockGetter world, double x, double y, double z, int freq) {
        super(world, x, y, z);
        this.jetStrength = strength;
        this.updateFrequency = freq;
        this.particleMaxAge = (RANDOM.nextInt(strength) + 2) * 20;
    }

    protected abstract void spawnJetParticle();

    @Override
    public boolean shouldDie() {
        return this.particleAge >= this.particleMaxAge;
    }

    @Override
    public void think() {
        if (this.particleAge % this.updateFrequency == 0) {
            this.spawnJetParticle();
        }
        ++this.particleAge;
    }
}

