/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.effects.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import dynamiclabs.immersivefx.environs.effects.particles.ParticleHooks;
import dynamiclabs.immersivefx.lib.biomes.BiomeUtilities;
import dynamiclabs.immersivefx.lib.gui.Color;
import dynamiclabs.immersivefx.lib.particles.MotionMote;
import dynamiclabs.immersivefx.lib.particles.ParticleCollisionResult;
import dynamiclabs.immersivefx.lib.random.XorShiftRandom;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoteWaterSpray
extends MotionMote {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected float scale;
    protected final float texU1;
    protected final float texU2;
    protected final float texV1;
    protected final float texV2;

    public MoteWaterSpray(BlockGetter world, double x, double y, double z, double dX, double dY, double dZ) {
        super(world, x, y, z, dX, dY, dZ);
        this.maxAge = (int)(8.0f / (RANDOM.nextFloat() * 0.8f + 0.2f));
        this.scale = (RANDOM.nextFloat() * 0.5f + 0.5f) * 2.0f * 0.07f;
        int textureIdx = RANDOM.nextInt(4);
        int texX = textureIdx % 2;
        int texY = textureIdx / 2;
        this.texU1 = (float)texX * 0.5f;
        this.texU2 = this.texU1 + 0.5f;
        this.texV1 = (float)texY * 0.5f;
        this.texV2 = this.texV1 + 0.5f;
    }

    @Override
    public void configureColor() {
        Color waterColor = BiomeUtilities.getColorForLiquid(this.world, (BlockPos)this.position);
        this.red = waterColor.red();
        this.green = waterColor.green();
        this.blue = waterColor.blue();
        this.alpha = 0.99f;
    }

    @Override
    public void handleCollision(@Nonnull ParticleCollisionResult collision) {
        ParticleHooks.splashHandler((Fluid)Fluids.f_76193_, collision, false);
        super.handleCollision(collision);
    }

    @Override
    public void renderParticle(@Nonnull VertexConsumer buffer, @Nonnull Camera info, float partialTicks) {
        float x = this.renderX(info, partialTicks);
        float y = this.renderY(info, partialTicks);
        float z = this.renderZ(info, partialTicks);
        Quaternion quaternion = info.m_90591_();
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.m_122251_(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.m_122251_(quaternion);
            vector3f.m_122261_(this.scale);
            vector3f.m_122272_(x, y, z);
        }
        this.drawVertex(buffer, avector3f[0].m_122239_(), avector3f[0].m_122260_(), avector3f[0].m_122269_(), this.texU2, this.texV2);
        this.drawVertex(buffer, avector3f[1].m_122239_(), avector3f[1].m_122260_(), avector3f[1].m_122269_(), this.texU2, this.texV1);
        this.drawVertex(buffer, avector3f[2].m_122239_(), avector3f[2].m_122260_(), avector3f[2].m_122269_(), this.texU1, this.texV1);
        this.drawVertex(buffer, avector3f[3].m_122239_(), avector3f[3].m_122260_(), avector3f[3].m_122269_(), this.texU1, this.texV2);
    }
}

