/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.fog;

import dynamiclabs.immersivefx.environs.config.Config;
import dynamiclabs.immersivefx.environs.fog.FogResult;
import dynamiclabs.immersivefx.environs.fog.VanillaFogRangeCalculator;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.WorldUtils;
import javax.annotation.Nonnull;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;

@OnlyIn(value=Dist.CLIENT)
public class WeatherFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected static final float START_IMPACT = 0.9f;
    protected static final float END_IMPACT = 0.4f;
    protected final FogResult cache = new FogResult();

    public WeatherFogRangeCalculator() {
        super("WeatherFogRangeCalculator");
    }

    @Override
    public boolean enabled() {
        return (Boolean)Config.CLIENT.fog.enableWeatherFog.get();
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        this.cache.set(event);
        float rainStr = WorldUtils.getRainStrength((Level)GameUtils.getWorld(), (float)event.getPartialTicks());
        if (rainStr > 0.0f) {
            float startScale = 1.0f - 0.9f * rainStr;
            float endScale = 1.0f - 0.4f * rainStr;
            this.cache.set(this.cache.getStart() * startScale, this.cache.getEnd() * endScale);
        }
        return this.cache;
    }
}

