/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.library;

import com.google.common.base.Joiner;
import dynamiclabs.immersivefx.environs.effects.BlockEffect;
import dynamiclabs.immersivefx.environs.library.WeightedAcousticEntry;
import dynamiclabs.immersivefx.lib.WeightTable;
import dynamiclabs.immersivefx.lib.collections.ObjectArray;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlockStateData {
    public static final BlockStateData DEFAULT = new BlockStateData();
    protected final ObjectArray<WeightedAcousticEntry> sounds = new ObjectArray();
    protected final ObjectArray<BlockEffect> effects = new ObjectArray();
    protected final ObjectArray<BlockEffect> alwaysOn = new ObjectArray();
    protected int chance = 100;
    protected boolean hasSoundsAndEffects;
    protected boolean hasAlwaysOn;

    public void setChance(int chance) {
        this.chance = chance;
    }

    public int getChance() {
        return this.chance;
    }

    public void addSound(@Nonnull WeightedAcousticEntry sound) {
        this.sounds.add(sound);
    }

    public void clearSounds() {
        this.sounds.clear();
    }

    @Nonnull
    public Collection<WeightedAcousticEntry> getSounds() {
        return this.sounds;
    }

    public void addEffect(@Nonnull BlockEffect effect) {
        if (effect.getChance() > 0) {
            this.effects.add(effect);
        } else {
            this.alwaysOn.add(effect);
        }
    }

    public void clearEffects() {
        this.effects.clear();
        this.alwaysOn.clear();
    }

    @Nonnull
    public Collection<BlockEffect> getEffects() {
        return this.effects;
    }

    @Nonnull
    public Collection<BlockEffect> getAlwaysOnEffects() {
        return this.alwaysOn;
    }

    public IAcoustic getSoundToPlay(@Nonnull Random random) {
        if (this.sounds.size() > 0 && random.nextInt(this.getChance()) == 0) {
            WeightTable<IAcoustic> table = new WeightTable<IAcoustic>();
            for (WeightedAcousticEntry ae : this.sounds) {
                if (!ae.matches()) continue;
                table.add(ae);
            }
            return (IAcoustic)table.next();
        }
        return null;
    }

    public boolean hasSoundsOrEffects() {
        return this.hasSoundsAndEffects;
    }

    public boolean hasAlwaysOnEffects() {
        return this.hasAlwaysOn;
    }

    public void trim() {
        this.sounds.trim();
        this.effects.trim();
        this.alwaysOn.trim();
        this.hasSoundsAndEffects = this.sounds.size() > 0 || this.effects.size() > 0;
        this.hasAlwaysOn = this.alwaysOn.size() > 0;
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.sounds.size() > 0) {
            builder.append(" chance:").append(this.chance);
            builder.append("; sounds [");
            builder.append(Joiner.on((char)',').join(this.sounds));
            builder.append(']');
        } else {
            builder.append("NO SOUNDS");
        }
        if (this.effects != this.alwaysOn) {
            builder.append("; effects [");
            builder.append(Joiner.on((char)',').join(this.effects));
            builder.append(',');
            builder.append(Joiner.on((char)',').join(this.alwaysOn));
            builder.append(']');
        } else {
            builder.append("; NO EFFECTS");
        }
        return builder.toString();
    }
}

