/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.environs.library;

import com.google.common.collect.ImmutableSet;
import dynamiclabs.immersivefx.environs.library.BiomeInfo;
import dynamiclabs.immersivefx.environs.library.BiomeLibrary;
import dynamiclabs.immersivefx.environs.library.IBiome;
import dynamiclabs.immersivefx.lib.GameUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;

@OnlyIn(value=Dist.CLIENT)
public class FakeBiomeAdapter
implements IBiome {
    protected final String name;
    protected final ResourceLocation key;
    @Nonnull
    protected final BiomeInfo biomeData;

    public FakeBiomeAdapter(@Nonnull String name) {
        this.name = name;
        this.key = new ResourceLocation("environs", ("fake_" + name).replace(' ', '_').toLowerCase());
        this.biomeData = new BiomeInfo(this);
    }

    @Nonnull
    public BiomeInfo getBiomeData() {
        return this.biomeData;
    }

    @Override
    public Biome.Precipitation getPrecipitationType() {
        return FakeBiomeAdapter.getTrueBiome().getPrecipitationType();
    }

    @Override
    public float getFloatTemperature(@Nonnull BlockPos pos) {
        return FakeBiomeAdapter.getTrueBiome().getFloatTemperature(pos);
    }

    @Override
    public float getTemperature() {
        return FakeBiomeAdapter.getTrueBiome().getTemperature();
    }

    @Override
    public boolean isHighHumidity() {
        return FakeBiomeAdapter.getTrueBiome().isHighHumidity();
    }

    @Override
    public float getDownfall() {
        return FakeBiomeAdapter.getTrueBiome().getRainfall();
    }

    @Override
    public Biome getBiome() {
        return null;
    }

    @Override
    public ResourceLocation getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<BiomeDictionary.Type> getTypes() {
        return ImmutableSet.of();
    }

    @Override
    public boolean isFake() {
        return true;
    }

    private static BiomeInfo getTrueBiome() {
        return BiomeLibrary.getPlayerBiome(GameUtils.getPlayer(), true);
    }
}

