/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.logging;

import dynamiclabs.immersivefx.lib.logging.IModLog;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class ModLog
implements IModLog {
    private static final Pattern REGEX_SPLIT = Pattern.compile("\\n");
    @Nonnull
    private final Marker marker;
    @Nonnull
    private final Logger logger;
    private boolean debugging;
    private int traceMask;

    public ModLog(@Nonnull Class<?> clazz) {
        this(Objects.requireNonNull(clazz).getSimpleName());
    }

    public ModLog(@Nonnull String name) {
        this.logger = LogManager.getLogger((String)Objects.requireNonNull(name));
        this.marker = MarkerManager.getMarker((String)"MOD");
    }

    private static void outputLines(@Nullable Marker marker, @Nonnull ILoggit out, @Nonnull String format, Object ... parms) {
        for (String l : REGEX_SPLIT.split(String.format(format, parms))) {
            out.log(marker, l, new Object[0]);
        }
    }

    @Nonnull
    public IModLog createChild(@Nonnull Class<?> child) {
        return new ChildLog(this, Objects.requireNonNull(child));
    }

    public void setDebug(boolean flag) {
        this.debugging = flag;
    }

    public void setTraceMask(int mask) {
        this.traceMask = mask;
    }

    public boolean testTrace(int mask) {
        return (this.traceMask & mask) != 0;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    @Override
    public void info(@Nonnull String msg, Object ... parms) {
        this.info(this.marker, msg, parms);
    }

    private void info(@Nonnull Marker marker, @Nonnull String msg, Object ... parms) {
        ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), msg, parms);
    }

    @Override
    public void info(@Nonnull Supplier<String> message) {
        this.info(this.marker, message);
    }

    private void info(@Nonnull Marker marker, @Nonnull Supplier<String> message) {
        ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), message.get(), new Object[0]);
    }

    @Override
    public void warn(@Nonnull String msg, Object ... parms) {
        this.warn(this.marker, msg, parms);
    }

    private void warn(@Nonnull Marker marker, @Nonnull String msg, Object ... parms) {
        ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).warn(arg_0, arg_1, arg_2), msg, parms);
    }

    @Override
    public void warn(@Nonnull Supplier<String> message) {
        this.warn(this.marker, message);
    }

    private void warn(@Nonnull Marker marker, @Nonnull Supplier<String> message) {
        ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).warn(arg_0, arg_1, arg_2), message.get(), new Object[0]);
    }

    @Override
    public void debug(@Nonnull String msg, Object ... parms) {
        this.debug(this.marker, msg, parms);
    }

    private void debug(@Nonnull Marker marker, @Nonnull String msg, Object ... parms) {
        if (this.isDebugging()) {
            ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), msg, parms);
        }
    }

    @Override
    public void debug(@Nonnull Supplier<String> message) {
        this.debug(this.marker, message);
    }

    private void debug(@Nonnull Marker marker, @Nonnull Supplier<String> message) {
        if (this.isDebugging()) {
            ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), message.get(), new Object[0]);
        }
    }

    @Override
    public void debug(int mask, @Nonnull String msg, Object ... parms) {
        this.debug(this.marker, msg, parms);
    }

    private void debug(@Nonnull Marker marker, int mask, @Nonnull String msg, Object ... parms) {
        if (this.isDebugging() && this.testTrace(mask)) {
            ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), msg, parms);
        }
    }

    @Override
    public void debug(int mask, @Nonnull Supplier<String> message) {
        this.debug(this.marker, message);
    }

    private void debug(@Nonnull Marker marker, int mask, @Nonnull Supplier<String> message) {
        if (this.isDebugging() && this.testTrace(mask)) {
            ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).info(arg_0, arg_1, arg_2), message.get(), new Object[0]);
        }
    }

    @Override
    public void error(@Nonnull Throwable e, @Nonnull String msg, Object ... parms) {
        this.error(this.marker, e, msg, parms);
    }

    private void error(@Nonnull Marker marker, @Nonnull Throwable e, @Nonnull String msg, Object ... parms) {
        ModLog.outputLines(marker, (arg_0, arg_1, arg_2) -> ((Logger)this.logger).error(arg_0, arg_1, arg_2), msg, parms);
        e.printStackTrace();
    }

    @Override
    public void error(@Nonnull Throwable e, @Nonnull Supplier<String> message) {
        this.error(this.marker, e, message);
    }

    private void error(@Nonnull Marker marker, @Nonnull Throwable e, @Nonnull Supplier<String> message) {
        this.error(marker, e, message.get(), new Object[0]);
    }

    @FunctionalInterface
    private static interface ILoggit {
        public void log(Marker var1, String var2, Object ... var3);
    }

    private static class ChildLog
    implements IModLog {
        @Nonnull
        private final ModLog parent;
        @Nonnull
        private final Marker marker;

        ChildLog(@Nonnull ModLog parent, @Nonnull Class<?> child) {
            this.parent = parent;
            this.marker = MarkerManager.getMarker((String)child.getSimpleName());
        }

        @Override
        public void info(@Nonnull String msg, Object ... parms) {
            this.parent.info(this.marker, msg, parms);
        }

        @Override
        public void info(@Nonnull Supplier<String> message) {
            this.parent.info(this.marker, message);
        }

        @Override
        public void warn(@Nonnull String msg, Object ... parms) {
            this.parent.warn(this.marker, msg, parms);
        }

        @Override
        public void warn(@Nonnull Supplier<String> message) {
            this.parent.warn(this.marker, message);
        }

        @Override
        public void debug(@Nonnull String msg, Object ... parms) {
            this.parent.debug(this.marker, msg, parms);
        }

        @Override
        public void debug(@Nonnull Supplier<String> message) {
            this.parent.debug(this.marker, message);
        }

        @Override
        public void debug(int mask, @Nonnull String msg, Object ... parms) {
            this.parent.debug(this.marker, mask, msg, parms);
        }

        @Override
        public void debug(int mask, @Nonnull Supplier<String> message) {
            this.parent.debug(this.marker, mask, message);
        }

        @Override
        public void error(@Nonnull Throwable e, @Nonnull String msg, Object ... parms) {
            this.parent.error(this.marker, e, msg, parms);
        }

        @Override
        public void error(@Nonnull Throwable e, @Nonnull Supplier<String> message) {
            this.parent.error(this.marker, e, message);
        }
    }
}

