/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.TickCounter;
import dynamiclabs.immersivefx.lib.collections.ObjectArray;
import dynamiclabs.immersivefx.lib.math.LoggingTimerEMA;
import dynamiclabs.immersivefx.lib.math.TimerEMA;
import dynamiclabs.immersivefx.lib.particles.BaseParticle;
import dynamiclabs.immersivefx.lib.particles.FrustumHelper;
import dynamiclabs.immersivefx.lib.particles.IParticleMote;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
final class ParticleCollection
extends BaseParticle {
    public static final ICollectionFactory FACTORY = ParticleCollection::new;
    protected static final int MAX_PARTICLES = 4000;
    protected static final int ALLOCATION_SIZE = 128;
    protected static final int TICK_GRACE = 2;
    private static final Predicate<IParticleMote> UPDATE_REMOVE = mote -> !mote.tick();
    protected final LoggingTimerEMA render;
    protected final LoggingTimerEMA tick;
    protected final ObjectArray<IParticleMote> myParticles = new ObjectArray(128);
    protected final ParticleRenderType renderType;
    protected long lastTickUpdate;

    ParticleCollection(@Nonnull String name, @Nonnull Level world, @Nonnull ParticleRenderType renderType) {
        super(world, 0.0, 0.0, 0.0);
        this.f_107219_ = false;
        this.renderType = renderType;
        this.render = new LoggingTimerEMA("Render " + name);
        this.tick = new LoggingTimerEMA("Tick " + name);
        this.lastTickUpdate = TickCounter.getTickCount();
    }

    public boolean canFit() {
        return this.myParticles.size() < 4000;
    }

    public void addParticle(@Nonnull IParticleMote mote) {
        if (this.canFit()) {
            this.myParticles.add(mote);
        }
    }

    public int size() {
        return this.myParticles.size();
    }

    @Nonnull
    public TimerEMA getRenderTimer() {
        return this.render;
    }

    @Nonnull
    public TimerEMA getTickTimer() {
        return this.tick;
    }

    public boolean shouldDie() {
        boolean timeout = TickCounter.getTickCount() - this.lastTickUpdate > 2L;
        return timeout || this.size() == 0 || this.f_107208_ != GameUtils.getWorld();
    }

    public void m_5989_() {
        this.tick.begin();
        if (this.m_107276_()) {
            this.lastTickUpdate = TickCounter.getTickCount();
            this.myParticles.removeIf(UPDATE_REMOVE);
            if (this.shouldDie()) {
                this.m_107274_();
            }
        }
        this.tick.end();
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5744_(@Nonnull VertexConsumer buffer, @Nonnull Camera renderInfo, float partialTicks) {
        this.render.begin();
        for (IParticleMote mote : this.myParticles) {
            if (!FrustumHelper.isLocationInFrustum(mote.getPosition())) continue;
            mote.renderParticle(buffer, renderInfo, partialTicks);
        }
        this.render.end();
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return this.renderType;
    }

    public static interface ICollectionFactory {
        public ParticleCollection create(@Nonnull String var1, @Nonnull Level var2, @Nonnull ParticleRenderType var3);
    }
}

