/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.resource;

import dynamiclabs.immersivefx.lib.Singleton;
import dynamiclabs.immersivefx.lib.resource.IResourceAccessor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
abstract class ResourceAccessorBase
implements IResourceAccessor {
    private final ResourceLocation location;
    private final Singleton<byte[]> bytes;

    public ResourceAccessorBase(@Nonnull ResourceLocation location) {
        this.location = location;
        this.bytes = new Singleton<byte[]>(this::getAsset);
    }

    @Override
    public ResourceLocation location() {
        return this.location;
    }

    @Override
    public byte[] asBytes() {
        return this.bytes.get();
    }

    @Nullable
    protected abstract byte[] getAsset();

    public String toString() {
        return this.location.toString();
    }
}

