/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.lib.scripting.sets;

import dynamiclabs.immersivefx.lib.DayCycle;
import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.scripting.VariableSet;
import dynamiclabs.immersivefx.lib.scripting.sets.IDiurnalCycle;
import dynamiclabs.immersivefx.lib.scripting.sets.LazyVariable;
import javax.annotation.Nonnull;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DiurnalCycleVariables
extends VariableSet<IDiurnalCycle>
implements IDiurnalCycle {
    private final LazyVariable<Float> moonPhaseFactor = new LazyVariable<Float>(() -> Float.valueOf(GameUtils.isInGame() ? DayCycle.getMoonPhaseFactor((LevelAccessor)GameUtils.getWorld()) : 0.0f));
    private final LazyVariable<Float> celestialAngle = new LazyVariable<Float>(() -> Float.valueOf(GameUtils.isInGame() ? GameUtils.getWorld().m_46942_(0.0f) : 0.0f));
    private boolean isAuroraVisible;
    private boolean isDay;
    private boolean isNight;
    private boolean isSunrise;
    private boolean isSunset;

    public DiurnalCycleVariables() {
        super("diurnal");
    }

    @Override
    @Nonnull
    public IDiurnalCycle getInterface() {
        return this;
    }

    @Override
    public void update() {
        if (GameUtils.isInGame()) {
            DayCycle cycle = DayCycle.getCycle((LevelAccessor)GameUtils.getWorld());
            this.isAuroraVisible = cycle.isAuroraVisible();
            this.isDay = cycle == DayCycle.DAYTIME;
            this.isNight = cycle == DayCycle.NIGHTTIME;
            this.isSunrise = cycle == DayCycle.SUNRISE;
            this.isSunset = cycle == DayCycle.SUNSET;
        } else {
            this.isAuroraVisible = false;
            this.isDay = false;
            this.isNight = false;
            this.isSunrise = false;
            this.isSunset = false;
        }
        this.moonPhaseFactor.reset();
        this.celestialAngle.reset();
    }

    @Override
    public boolean isDay() {
        return this.isDay;
    }

    @Override
    public boolean isNight() {
        return this.isNight;
    }

    @Override
    public boolean isSunrise() {
        return this.isSunrise;
    }

    @Override
    public boolean isSunset() {
        return this.isSunset;
    }

    @Override
    public boolean isAuroraVisible() {
        return this.isAuroraVisible;
    }

    @Override
    public float getMoonPhaseFactor() {
        return this.moonPhaseFactor.get().floatValue();
    }

    @Override
    public float getCelestialAngle() {
        return this.celestialAngle.get().floatValue();
    }
}

