/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.mobeffects.footsteps;

import dynamiclabs.immersivefx.lib.GameUtils;
import dynamiclabs.immersivefx.lib.TickCounter;
import dynamiclabs.immersivefx.lib.collections.ObjectArray;
import dynamiclabs.immersivefx.lib.logging.IModLog;
import dynamiclabs.immersivefx.lib.math.MathStuff;
import dynamiclabs.immersivefx.lib.random.XorShiftRandom;
import dynamiclabs.immersivefx.mobeffects.MobEffects;
import dynamiclabs.immersivefx.mobeffects.config.Config;
import dynamiclabs.immersivefx.mobeffects.effects.particles.Collections;
import dynamiclabs.immersivefx.mobeffects.footsteps.AcousticResolver;
import dynamiclabs.immersivefx.mobeffects.footsteps.Association;
import dynamiclabs.immersivefx.mobeffects.footsteps.FootStrikeLocation;
import dynamiclabs.immersivefx.mobeffects.footsteps.Footprint;
import dynamiclabs.immersivefx.mobeffects.footsteps.FootprintStyle;
import dynamiclabs.immersivefx.mobeffects.footsteps.Substrate;
import dynamiclabs.immersivefx.mobeffects.footsteps.Variator;
import dynamiclabs.immersivefx.mobeffects.footsteps.accents.FootstepAccents;
import dynamiclabs.immersivefx.mobeffects.library.Constants;
import dynamiclabs.immersivefx.mobeffects.library.FootstepLibrary;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.AcousticEvent;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.AcousticCompiler;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

@OnlyIn(value=Dist.CLIENT)
public class Generator {
    protected static final IModLog LOGGER = MobEffects.LOGGER.createChild(Generator.class);
    public static final double PROBE_DEPTH = 0.0625;
    protected static final Random RANDOM = XorShiftRandom.current();
    protected static final int BRUSH_INTERVAL = 2;
    protected final Variator VAR;
    protected float dmwBase;
    protected float dwmYChange;
    protected double yPosition;
    protected double prevX = Double.MIN_VALUE;
    protected double prevY = Double.MIN_VALUE;
    protected double prevZ = Double.MIN_VALUE;
    protected boolean didJump;
    protected boolean isFlying;
    protected float fallDistance;
    protected float lastReference;
    protected boolean isImmobile;
    protected long timeImmobile;
    protected boolean isRightFoot;
    protected boolean isOnGround;
    protected boolean isOnLadder;
    protected boolean isInWater;
    protected boolean isSneaking;
    protected boolean isJumping;
    protected double xMovec;
    protected double zMovec;
    protected boolean scalStat;
    protected boolean stepThisFrame;
    protected BlockPos messyPos = BlockPos.f_121853_;
    protected long brushesTime;
    protected double distanceWalkedOnStepModified;
    protected int pedometer;
    protected static final ObjectArray<IAcoustic> accents = new ObjectArray();

    public Generator(@Nonnull Variator var) {
        this.VAR = var;
    }

    public int getPedometer() {
        return this.pedometer;
    }

    public void generateFootsteps(@Nonnull LivingEntity entity) {
        if (entity.m_146898_() || entity.m_5803_()) {
            return;
        }
        if (entity instanceof Player && entity.m_5833_()) {
            return;
        }
        this.didJump = false;
        this.stepThisFrame = false;
        this.isOnGround = entity.m_20096_();
        this.isOnLadder = this.isClimbing(entity);
        this.isInWater = entity.m_20069_();
        this.isSneaking = entity.m_6144_();
        this.isJumping = entity.f_20899_;
        this.simulateFootsteps(entity);
        this.simulateAirborne(entity);
        this.simulateBrushes(entity);
        if (this.stepThisFrame) {
            ++this.pedometer;
        }
        if (Constants.FOOTSTEPS.getVolumeScale() > 0.0f) {
            entity.f_19829_ = Float.MAX_VALUE;
        } else {
            float dist = entity.f_19829_;
            if (dist == Float.MAX_VALUE) {
                entity.f_19829_ = 0.0f;
            }
        }
    }

    protected boolean isClimbing(@Nonnull LivingEntity entity) {
        BlockPos blockPos;
        Level world = entity.m_20193_();
        BlockState blockState = world.m_8055_(blockPos = entity.m_142538_());
        return blockState.m_204336_(BlockTags.f_13082_) || ForgeHooks.isLivingOnLadder((BlockState)blockState, (Level)world, (BlockPos)blockPos, (LivingEntity)entity).isPresent();
    }

    protected boolean stoppedImmobile(float reference) {
        long current = TickCounter.getTickCount();
        float diff = this.lastReference - reference;
        this.lastReference = reference;
        if (!this.isImmobile && diff == 0.0f) {
            this.timeImmobile = current;
            this.isImmobile = true;
        } else if (this.isImmobile && diff != 0.0f) {
            this.isImmobile = false;
            return current - this.timeImmobile > (long)this.VAR.IMMOBILE_DURATION;
        }
        return false;
    }

    protected void updateWalkedOnStep(@Nonnull LivingEntity entity) {
        float distance = 0.0f;
        if (Double.compare(this.prevX, Double.MIN_VALUE) == 0) {
            this.prevX = entity.m_20185_();
            this.prevY = entity.m_20186_();
            this.prevZ = entity.m_20189_();
        } else {
            double dX = entity.m_20185_() - this.prevX;
            double dY = entity.m_20186_() - this.prevY;
            double dZ = entity.m_20189_() - this.prevZ;
            this.prevX = entity.m_20185_();
            this.prevY = entity.m_20186_();
            this.prevZ = entity.m_20189_();
            double sqrt = entity.m_20096_() ? Math.sqrt(dX * dX + dZ * dZ) : Math.sqrt(dX * dX + dY * dY + dZ * dZ);
            distance = (float)sqrt * 0.6f;
        }
        this.distanceWalkedOnStepModified += (double)distance;
    }

    protected void simulateFootsteps(@Nonnull LivingEntity entity) {
        double movZ;
        double movX;
        double scal;
        this.updateWalkedOnStep(entity);
        float distanceReference = (float)this.distanceWalkedOnStepModified;
        if (this.dmwBase > distanceReference) {
            this.dmwBase = 0.0f;
            this.dwmYChange = 0.0f;
        }
        if (this.scalStat != (scal = (movX = entity.m_20184_().f_82479_) * this.xMovec + (movZ = entity.m_20184_().f_82481_) * this.zMovec) < (double)0.001f) {
            boolean bl = this.scalStat = !this.scalStat;
            if (this.scalStat && this.VAR.PLAY_WANDER && !this.hasSpecialStoppingConditions(entity)) {
                this.playSinglefoot(entity, 0.0, Constants.WANDER, this.isRightFoot);
            }
        }
        this.xMovec = movX;
        this.zMovec = movZ;
        if (this.isOnGround || this.isInWater || this.isOnLadder) {
            AcousticEvent event = null;
            float dwm = distanceReference - this.dmwBase;
            boolean immobile = this.stoppedImmobile(distanceReference);
            if (immobile && !this.isOnLadder) {
                dwm = 0.0f;
                this.dmwBase = distanceReference;
            }
            float distance = 0.0f;
            if (this.isOnLadder && !this.isOnGround) {
                distance = this.VAR.STRIDE_LADDER;
            } else if (!this.isInWater && MathStuff.abs(this.yPosition - entity.m_20186_()) > 0.4) {
                if (this.yPosition < entity.m_20186_()) {
                    distance = this.VAR.STRIDE_STAIR;
                    event = this.speedDisambiguator(entity, Constants.UP, Constants.UP_RUN);
                } else if (!this.isSneaking) {
                    distance = -1.0f;
                    event = this.speedDisambiguator(entity, Constants.DOWN, Constants.DOWN_RUN);
                }
                this.dwmYChange = distanceReference;
            } else {
                distance = this.VAR.STRIDE;
            }
            if (event == null) {
                event = this.speedDisambiguator(entity, Constants.WALK, Constants.RUN);
            }
            if (dwm > (distance = this.reevaluateDistance(event, distance))) {
                this.produceStep(entity, event, 0.0);
                this.stepped(entity, event);
                this.dmwBase = distanceReference;
            }
        }
        if (this.isOnGround) {
            this.yPosition = entity.m_20186_();
        }
    }

    protected void stepped(@Nonnull LivingEntity entity, @Nonnull AcousticEvent event) {
    }

    protected float reevaluateDistance(@Nonnull AcousticEvent event, float distance) {
        return distance;
    }

    protected void produceStep(@Nonnull LivingEntity entity, @Nonnull AcousticEvent event) {
        this.produceStep(entity, event, 0.0);
    }

    protected void produceStep(@Nonnull LivingEntity entity, @Nullable AcousticEvent event, double verticalOffsetAsMinus) {
        if (!this.playSpecialStoppingConditions(entity)) {
            if (event == null) {
                event = this.speedDisambiguator(entity, Constants.WALK, Constants.RUN);
            }
            this.playSinglefoot(entity, verticalOffsetAsMinus, event, this.isRightFoot);
            this.isRightFoot = !this.isRightFoot;
        }
        this.stepThisFrame = true;
    }

    protected void simulateAirborne(@Nonnull LivingEntity entity) {
        if ((this.isOnGround || this.isOnLadder) == this.isFlying) {
            this.isFlying = !this.isFlying;
            this.simulateJumpingLanding(entity);
        }
        if (this.isFlying) {
            this.fallDistance = entity.f_19789_;
        }
    }

    protected void simulateJumpingLanding(@Nonnull LivingEntity entity) {
        if (this.hasSpecialStoppingConditions(entity)) {
            return;
        }
        if (this.isFlying && this.isJumping) {
            if (this.VAR.EVENT_ON_JUMP && entity.m_20184_().f_82480_ > 0.0) {
                this.didJump = true;
                double speed = entity.m_20184_().f_82479_ * entity.m_20184_().f_82479_ + entity.m_20184_().f_82481_ * entity.m_20184_().f_82481_;
                if (speed < (double)this.VAR.SPEED_TO_JUMP_AS_MULTIFOOT) {
                    this.playMultifoot(entity, 0.4, Constants.JUMP);
                } else {
                    this.playSinglefoot(entity, 0.4, Constants.JUMP, this.isRightFoot);
                }
            }
        } else if (!this.isFlying && this.fallDistance > 0.01f) {
            if (this.fallDistance > this.VAR.LAND_HARD_DISTANCE_MIN) {
                this.playMultifoot(entity, 0.0, Constants.LAND);
            } else if (!this.stepThisFrame && !this.isSneaking) {
                this.playSinglefoot(entity, 0.0, this.speedDisambiguator(entity, Constants.CLIMB, Constants.CLIMB_RUN), this.isRightFoot);
                this.isRightFoot = !this.isRightFoot;
            }
        }
    }

    protected AcousticEvent speedDisambiguator(@Nonnull LivingEntity entity, @Nonnull AcousticEvent walk, @Nonnull AcousticEvent run) {
        double velocity = entity.m_20184_().f_82479_ * entity.m_20184_().f_82479_ + entity.m_20184_().f_82481_ * entity.m_20184_().f_82481_;
        return velocity > (double)this.VAR.SPEED_TO_RUN ? run : walk;
    }

    protected void simulateBrushes(@Nonnull LivingEntity entity) {
        long current = TickCounter.getTickCount();
        if (current >= this.brushesTime) {
            this.brushesTime = current + 2L;
            if (this.proceedWithStep(entity) && (entity.m_20184_().f_82479_ != 0.0 || entity.m_20184_().f_82481_ != 0.0)) {
                int yy = MathStuff.floor(entity.m_20186_() - 0.0625 - entity.m_6049_() - (entity.m_20096_() ? 0.0 : 0.25));
                BlockPos pos = new BlockPos(entity.m_20185_(), (double)yy, entity.m_20189_());
                if (!this.messyPos.equals((Object)pos)) {
                    this.messyPos = pos;
                    Association assos = this.findAssociationMessyFoliage(entity, pos);
                    if (assos != null) {
                        this.playAssociation(assos, Constants.WALK);
                    }
                }
            }
        }
    }

    protected boolean proceedWithStep(@Nonnull LivingEntity entity) {
        return !this.isSneaking;
    }

    protected void playSinglefoot(@Nonnull LivingEntity entity, double verticalOffsetAsMinus, @Nonnull AcousticEvent eventType, boolean foot) {
        if (this.proceedWithStep(entity)) {
            Association assos = this.findAssociation(entity, verticalOffsetAsMinus, foot);
            this.playAssociation(assos, eventType);
        }
    }

    protected void playMultifoot(@Nonnull LivingEntity entity, double verticalOffsetAsMinus, AcousticEvent eventType) {
        if (this.proceedWithStep(entity)) {
            Association leftFoot = this.findAssociation(entity, verticalOffsetAsMinus, false);
            Association rightFoot = this.findAssociation(entity, verticalOffsetAsMinus, true);
            this.playAssociation(leftFoot, eventType);
            this.playAssociation(rightFoot, eventType);
        }
    }

    protected void playAssociation(@Nullable Association assoc, @Nonnull AcousticEvent eventType) {
        if (assoc != null) {
            assoc.play(eventType);
        }
    }

    protected boolean shouldProducePrint(@Nonnull LivingEntity entity) {
        return this.VAR.HAS_FOOTPRINT && (Boolean)Config.CLIENT.footsteps.enableFootprintParticles.get() != false && (this.isOnGround || !this.isJumping && !entity.f_19812_) && !entity.m_20177_(GameUtils.getPlayer());
    }

    @Nullable
    protected Association findAssociation(@Nonnull LivingEntity entity, double verticalOffsetAsMinus, boolean isRightFoot) {
        Vec3 printPos;
        float rotDegrees = MathStuff.wrapDegrees(entity.m_146908_());
        double rot = MathStuff.toRadians(rotDegrees);
        float feetDistanceToCenter = isRightFoot ? -this.VAR.DISTANCE_TO_CENTER : this.VAR.DISTANCE_TO_CENTER;
        double xx = entity.m_20185_() + MathStuff.cos(rot) * (double)feetDistanceToCenter;
        double zz = entity.m_20189_() + MathStuff.sin(rot) * (double)feetDistanceToCenter;
        double minY = entity.m_142469_().f_82289_;
        FootStrikeLocation loc = new FootStrikeLocation(entity, xx, minY - 0.0625 - verticalOffsetAsMinus, zz);
        AcousticResolver resolver = new AcousticResolver((LevelReader)entity.m_20193_(), loc, this.VAR.DISTANCE_TO_CENTER);
        Association result = this.addFootstepAccent(entity, resolver.findAssociation());
        if (result != null && this.shouldProducePrint(entity) && (printPos = result.getStrikeLocation().footprintPosition()) != null) {
            FootprintStyle style = this.VAR.FOOTPRINT_STYLE;
            if (entity instanceof Player) {
                style = (FootprintStyle)((Object)Config.CLIENT.footsteps.playerFootprintStyle.get());
            }
            Footprint print = Footprint.produce(style, entity, printPos, rotDegrees, this.VAR.FOOTPRINT_SCALE, isRightFoot);
            Vec3 stepLocation = print.getStepLocation();
            Level world = print.getEntity().m_20193_();
            Collections.addFootprint(print.getStyle(), world, stepLocation, print.getRotation(), print.getScale(), print.isRightFoot());
        }
        return result;
    }

    protected boolean playSpecialStoppingConditions(@Nonnull LivingEntity entity) {
        if (entity.m_20069_()) {
            if (this.proceedWithStep(entity)) {
                FluidState fs = entity.m_20193_().m_6425_(new BlockPos(entity.m_20299_(1.0f)));
                AcousticEvent evt = fs.m_76178_() ? Constants.WALK : Constants.SWIM;
                FootstepLibrary.getSwimAcoustic().playAt(entity.m_20182_(), evt);
            }
            return true;
        }
        return false;
    }

    protected boolean hasSpecialStoppingConditions(@Nonnull LivingEntity entity) {
        return entity.m_20069_();
    }

    @Nullable
    protected Association findAssociationMessyFoliage(@Nonnull LivingEntity entity, @Nonnull BlockPos pos) {
        IAcoustic acoustics;
        Association result = null;
        BlockPos up = pos.m_7494_();
        BlockState above = entity.m_20193_().m_8055_(up);
        if (above.m_60767_() != Material.f_76296_ && (acoustics = FootstepLibrary.getBlockAcoustics(above, Substrate.MESSY)) == Constants.MESSY_GROUND && (acoustics = FootstepLibrary.getBlockAcoustics(above, Substrate.FOLIAGE)) != Constants.NOT_EMITTER) {
            result = new Association(entity, acoustics);
        }
        return result;
    }

    @Nullable
    protected Association addFootstepAccent(@Nonnull LivingEntity entity, @Nullable Association assoc) {
        if (entity.m_20096_()) {
            accents.clear();
            BlockPos pos = assoc != null ? assoc.getStepPos() : entity.m_142538_();
            FootstepAccents.provide(entity, pos, accents);
            if (accents.size() > 0) {
                if (assoc == null) {
                    IAcoustic acoustic = AcousticCompiler.combine(accents);
                    assoc = new Association(entity, acoustic);
                } else {
                    assoc.merge(accents.toArray((IAcoustic[])new IAcoustic[0]));
                }
            }
        }
        return assoc;
    }

    public String toString() {
        return "didJump: " + this.didJump + " onLadder: " + this.isOnLadder + " flying: " + this.isFlying + " immobile: " + this.isImmobile + " steps: " + this.pedometer;
    }
}

