/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.api.effects;

import com.google.common.base.MoreObjects;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.api.effects.IEntityEffectManager;
import dynamiclabs.immersivefx.sndctrl.library.AcousticLibrary;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.Particle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractEntityEffect {
    private IEntityEffectManager manager;
    private final ResourceLocation name;

    protected AbstractEntityEffect(@Nonnull ResourceLocation name) {
        this.name = name;
    }

    @Nonnull
    public ResourceLocation getName() {
        return this.name;
    }

    @Nonnull
    public LivingEntity getEntity() {
        return this.manager.getEntity();
    }

    public void intitialize(@Nonnull IEntityEffectManager manager) {
        this.manager = manager;
    }

    public abstract void update();

    public boolean receiveLastCall() {
        return false;
    }

    public void die() {
    }

    public boolean isFirstPersonView() {
        return this.manager.isFirstPersonView();
    }

    public void addParticle(@Nonnull Particle particle) {
        this.manager.addParticle(particle);
    }

    public boolean isActivePlayer(@Nonnull LivingEntity entity) {
        return this.manager.isActivePlayer(entity);
    }

    @Nonnull
    public Player thePlayer() {
        return this.manager.thePlayer();
    }

    @Nonnull
    public IAcoustic resolveAcoustic(@Nonnull ResourceLocation acousticId) {
        return AcousticLibrary.resolve(acousticId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getName().toString()).toString();
    }
}

