/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.audio.acoustic;

import com.google.common.base.MoreObjects;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.AcousticEvent;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcousticFactory;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EventSelectorAcoustic
implements IAcoustic {
    private final Map<AcousticEvent, IAcoustic> mapping = new IdentityHashMap<AcousticEvent, IAcoustic>(4);
    @Nonnull
    private final ResourceLocation name;

    public EventSelectorAcoustic(@Nonnull ResourceLocation name) {
        this.name = Objects.requireNonNull(name);
    }

    public void add(@Nonnull AcousticEvent event, @Nonnull IAcoustic acoustic) {
        this.mapping.put(event, acoustic);
    }

    @Override
    @Nonnull
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public void play(@Nonnull AcousticEvent event) {
        this.resolve(event).ifPresent(IAcoustic::play);
    }

    @Override
    public void playAt(@Nonnull BlockPos pos, @Nonnull AcousticEvent event) {
        this.resolve(event).ifPresent(a -> a.playAt(pos));
    }

    @Override
    public void playAt(@Nonnull Vec3 pos, @Nonnull AcousticEvent event) {
        this.resolve(event).ifPresent(a -> a.playAt(pos));
    }

    @Override
    public void playNear(@Nonnull Entity entity, @Nonnull AcousticEvent event) {
        this.resolve(event).ifPresent(a -> a.playNear(entity));
    }

    @Override
    public void playNear(@Nonnull Entity entity, @Nonnull AcousticEvent event, int minRange, int maxRange) {
        this.resolve(event).ifPresent(a -> a.playNear(entity, minRange, maxRange));
    }

    @Override
    public void playBackground(@Nonnull AcousticEvent event) {
        this.resolve(event).ifPresent(IAcoustic::playBackground);
    }

    @Override
    public IAcousticFactory getFactory(@Nonnull AcousticEvent event) {
        return this.resolve(event).map(IAcoustic::getFactory).orElse(null);
    }

    @Nonnull
    protected Optional<IAcoustic> resolve(@Nonnull AcousticEvent event) {
        IAcoustic acoustic = this.mapping.get(event);
        if (acoustic == null && event.canTransition()) {
            acoustic = this.mapping.get(event.getTransition());
        }
        return Optional.ofNullable(acoustic);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getName().toString()).add("entries", this.mapping.size()).toString();
    }
}

