/*
 * Decompiled with CFR 0.152.
 */
package dynamiclabs.immersivefx.sndctrl.library;

import dynamiclabs.immersivefx.dsurround.DynamicSurroundings;
import dynamiclabs.immersivefx.lib.logging.IModLog;
import dynamiclabs.immersivefx.lib.resource.IResourceAccessor;
import dynamiclabs.immersivefx.lib.resource.ResourceUtils;
import dynamiclabs.immersivefx.sndctrl.SoundControl;
import dynamiclabs.immersivefx.sndctrl.api.acoustics.IAcoustic;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.AcousticCompiler;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.NullAcoustic;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.SimpleAcoustic;
import dynamiclabs.immersivefx.sndctrl.audio.acoustic.SimultaneousAcoustic;
import dynamiclabs.immersivefx.sndctrl.library.AudioEffectLibrary;
import dynamiclabs.immersivefx.sndctrl.library.SoundLibrary;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class AcousticLibrary {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(AudioEffectLibrary.class);
    private static final ResourceLocation ADHOC = new ResourceLocation("sndctrl", "ad_hoc");
    private static final Map<String, IAcoustic> compiled = new Object2ObjectAVLTreeMap();

    AcousticLibrary() {
    }

    public static Stream<String> dump() {
        return compiled.entrySet().stream().map(kvp -> String.format("%s -> %s", kvp.getKey(), ((IAcoustic)kvp.getValue()).toString())).sorted();
    }

    public static void addAcoustic(@Nonnull ResourceLocation name, @Nonnull IAcoustic acoustic) {
        compiled.put(name.toString(), acoustic);
    }

    public static void initialize() {
        Collection<IResourceAccessor> configs = ResourceUtils.findConfigs("dsurround", DynamicSurroundings.DATA_PATH, "acoustics.json");
        IResourceAccessor.process(configs, accessor -> {
            AcousticCompiler compiler = new AcousticCompiler(accessor.location().m_135827_());
            List<IAcoustic> acoustics = compiler.compile(accessor.asString());
            for (IAcoustic a : acoustics) {
                AcousticLibrary.addAcoustic(a.getName(), a);
            }
        });
    }

    @Nonnull
    public static IAcoustic resolve(@Nonnull String namespace, @Nonnull String definition, @Nullable Function<ResourceLocation, IAcoustic> acousticGenerator) {
        IAcoustic result = compiled.get(definition = Arrays.stream(definition.toLowerCase().split(",")).map(frag -> AcousticLibrary.resolveResource(namespace, frag).toString()).sorted().collect(Collectors.joining(",")));
        if (result == null) {
            result = AcousticLibrary.parseDefinition(null, definition, acousticGenerator);
        }
        compiled.put(definition, result);
        return result;
    }

    @Nonnull
    public static IAcoustic resolve(@Nonnull ResourceLocation acousticName) {
        return AcousticLibrary.resolve(acousticName, null);
    }

    @Nonnull
    private static IAcoustic parseDefinition(@Nullable ResourceLocation acousticName, @Nullable String definition, @Nullable Function<ResourceLocation, IAcoustic> acousticGenerator) {
        IAcoustic result;
        if (!StringUtil.m_14408_((String)definition)) {
            if (acousticName == null) {
                acousticName = ADHOC;
            }
            String nameSpace = acousticName.m_135827_();
            IAcoustic[] acoustics = (IAcoustic[])Arrays.stream(definition.split(",")).map(fragment -> {
                ResourceLocation fragLoc = AcousticLibrary.resolveResource(nameSpace, fragment);
                IAcoustic a = null;
                if (acousticGenerator != null) {
                    a = (IAcoustic)acousticGenerator.apply(fragLoc);
                }
                if (a == null) {
                    a = AcousticLibrary.generateAcoustic(fragLoc);
                }
                if (a == null) {
                    SoundControl.LOGGER.warn("Acoustic '%s' not found!", fragment);
                }
                return a;
            }).filter(Objects::nonNull).toArray(IAcoustic[]::new);
            if (acoustics.length == 0) {
                result = NullAcoustic.INSTANCE;
            } else if (acoustics.length == 1) {
                result = acoustics[0];
            } else {
                SimultaneousAcoustic s = new SimultaneousAcoustic(acousticName);
                for (IAcoustic t : acoustics) {
                    s.add(t);
                }
                s.trim();
                result = s;
            }
        } else {
            result = NullAcoustic.INSTANCE;
        }
        return result;
    }

    @Nonnull
    public static IAcoustic resolve(@Nonnull ResourceLocation acousticName, @Nullable String definition) {
        return AcousticLibrary.resolve(acousticName, definition, false);
    }

    public static IAcoustic resolve(@Nonnull ResourceLocation acousticName, @Nonnull ResourceLocation definition, @Nullable Function<ResourceLocation, IAcoustic> acousticGenerator) {
        IAcoustic result = compiled.get(acousticName.toString());
        if (result == null) {
            result = AcousticLibrary.parseDefinition(acousticName, definition.toString(), acousticGenerator);
            AcousticLibrary.addAcoustic(acousticName, result);
        }
        return result;
    }

    @Nonnull
    public static IAcoustic resolve(@Nonnull ResourceLocation acousticName, @Nullable String definition, boolean overwrite) {
        IAcoustic result = compiled.get(acousticName.toString());
        if (overwrite) {
            result = null;
        }
        if (result == null) {
            result = AcousticLibrary.parseDefinition(acousticName, definition, null);
            AcousticLibrary.addAcoustic(acousticName, result);
        }
        return result;
    }

    @Nonnull
    public static ResourceLocation resolveResource(@Nonnull String defaultDomain, @Nonnull String name) {
        if (StringUtil.m_14408_((String)name)) {
            throw new IllegalArgumentException("Sound name is null or empty");
        }
        if (StringUtil.m_14408_((String)defaultDomain)) {
            throw new IllegalArgumentException("Default domain is null or empty");
        }
        ResourceLocation res = name.charAt(0) == '@' ? new ResourceLocation("minecraft", name.substring(1)) : (!name.contains(":") ? new ResourceLocation(defaultDomain, name) : new ResourceLocation(name));
        return res;
    }

    @Nullable
    private static IAcoustic generateAcoustic(@Nonnull ResourceLocation name) {
        IAcoustic a = compiled.get(name.toString());
        if (a == null) {
            if (name.m_135815_().equals("not_emitter")) {
                a = NullAcoustic.INSTANCE;
            } else {
                Optional<SoundEvent> evt = SoundLibrary.getSound(name);
                if (evt.isPresent()) {
                    a = AcousticLibrary.generateAcoustic(evt.get());
                }
            }
        }
        return a;
    }

    @Nonnull
    private static IAcoustic generateAcoustic(@Nonnull SoundEvent evt) {
        IAcoustic result = compiled.get(evt.m_11660_().toString());
        if (result == null) {
            result = new SimpleAcoustic(evt);
        }
        return result;
    }
}

