/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.personality.client;

import com.teamabnormals.personality.client.PersonalityClient;
import com.teamabnormals.personality.client.SittableModel;
import com.teamabnormals.personality.common.CommonEvents;
import com.teamabnormals.personality.common.network.MessageC2SCrawl;
import com.teamabnormals.personality.common.network.MessageC2SSit;
import com.teamabnormals.personality.core.Personality;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="personality", value={Dist.CLIENT})
public class ClientEvents {
    public static boolean crawling;
    public static boolean sitting;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (PersonalityClient.CRAWL.m_90857_() && !sitting && CommonEvents.testCrawl((Player)player)) {
            if (!crawling) {
                crawling = true;
                player.setForcedPose(Pose.SWIMMING);
                Personality.CHANNEL.sendToServer((Object)new MessageC2SCrawl(true));
            }
        } else if (crawling) {
            crawling = false;
            player.setForcedPose(null);
            Personality.CHANNEL.sendToServer((Object)new MessageC2SCrawl(false));
        }
        Vec3 motion = player.m_20184_();
        if (PersonalityClient.SIT.m_90857_() && !crawling && Math.abs(motion.m_7096_()) <= 0.008 && Math.abs(motion.m_7094_()) <= 0.008 && CommonEvents.testSit((Player)player)) {
            if (!sitting) {
                sitting = true;
                Personality.SYNCED_SITTING_PLAYERS.add(player.m_142081_());
                player.m_6210_();
                Personality.CHANNEL.sendToServer((Object)new MessageC2SSit(true));
            }
        } else if (sitting) {
            sitting = false;
            Personality.SYNCED_SITTING_PLAYERS.remove(player.m_142081_());
            player.m_6210_();
            Personality.CHANNEL.sendToServer((Object)new MessageC2SSit(false));
        }
    }

    @SubscribeEvent
    public static void onEntitySize(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (sitting && !crawling && !CommonEvents.testSit(player)) {
            EntityDimensions size = Player.f_36088_;
            event.setNewSize(new EntityDimensions(size.f_20377_, size.f_20378_ - 0.5f, size.f_20379_));
            event.setNewEyeHeight(event.getOldEyeHeight() - 0.5f);
        }
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent event) {
        Player player = event.getPlayer();
        ((SittableModel)event.getRenderer().m_7200_()).setForcedSitting(Personality.SYNCED_SITTING_PLAYERS.contains(player.m_142081_()));
    }
}

