/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.personality.core.mixin;

import com.teamabnormals.personality.client.ClimbAnimation;
import com.teamabnormals.personality.common.CommonEvents;
import com.teamabnormals.personality.core.Personality;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements ClimbAnimation {
    private float climbAnim;
    private float prevClimbAnim;

    public PlayerMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"aiStep()V"}, at={@At(value="TAIL")})
    public void tickClimbAnim(CallbackInfo ci) {
        this.prevClimbAnim = this.climbAnim;
        this.climbAnim = CommonEvents.isClimbing((Player)this) ? Math.min(this.climbAnim + 1.0f, 4.0f) : Math.max(this.climbAnim - 1.0f, 0.0f);
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        double x = pos.m_7096_();
        double y = pos.m_7098_();
        double z = pos.m_7094_();
        if (Personality.SITTING_PLAYERS.contains(this.m_142081_()) && Math.cbrt(x * x + y * y + z * z) >= 0.185) {
            Personality.SITTING_PLAYERS.remove(this.m_142081_());
        }
        super.m_6478_(type, pos);
    }

    @Override
    public float getClimbAnim() {
        return this.climbAnim;
    }

    @Override
    public float getPrevClimbAnim() {
        return this.prevClimbAnim;
    }
}

