/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.supernatural.entity;

import java.util.Random;
import java.util.Set;
import net.mcreator.supernatural.init.SupernaturalModEntities;
import net.mcreator.supernatural.procedures.GhostTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class GhostEctoEntity
extends Monster {
    private static final Set<ResourceLocation> SPAWN_BIOMES = Set.of(new ResourceLocation("swamp"));

    @SubscribeEvent
    public static void addLivingEntityToBiomes(BiomeLoadingEvent event) {
        if (SPAWN_BIOMES.contains(event.getName())) {
            event.getSpawns().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)SupernaturalModEntities.GHOST_ECTO.get(), 5, 1, 3));
        }
    }

    public GhostEctoEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<GhostEctoEntity>)((EntityType)SupernaturalModEntities.GHOST_ECTO.get()), world);
    }

    public GhostEctoEntity(EntityType<GhostEctoEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 2;
        this.m_21557_(false);
        this.f_21342_ = new GhostMoveControl(this);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    public void m_6478_(MoverType p_33997_, Vec3 p_33998_) {
        super.m_6478_(p_33997_, p_33998_);
        this.m_20101_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.8, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true, true));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 m_7037_() {
                Random random = GhostEctoEntity.this.m_21187_();
                double dir_x = GhostEctoEntity.this.m_20185_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = GhostEctoEntity.this.m_20186_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = GhostEctoEntity.this.m_20189_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("supernatural:ghost_idle"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("supernatural:ghost_walk")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("supernatural:ghost_hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("supernatural:ghost_death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19310_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public boolean m_7327_(Entity target) {
        if (super.m_7327_(target)) {
            if (target instanceof LivingEntity) {
                if (this.f_19853_.m_46791_() == Difficulty.EASY) {
                    target.m_6469_(DamageSource.f_19319_, 1.0f);
                } else if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    target.m_6469_(DamageSource.f_19319_, 3.0f);
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    target.m_6469_(DamageSource.f_19319_, 5.0f);
                }
            }
            return true;
        }
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        GhostTickProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public void m_8107_() {
        this.f_19794_ = true;
        super.m_8107_();
        this.f_19794_ = false;
        this.m_20242_(true);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)SupernaturalModEntities.GHOST_ECTO.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)world, (BlockPos)pos, (Random)random) && Mob.m_21400_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 1.0);
        builder = builder.m_22268_(Attributes.f_22280_, 0.25);
        return builder;
    }

    static class GhostMoveControl
    extends MoveControl {
        private final GhostEctoEntity ghost;

        public GhostMoveControl(GhostEctoEntity ent) {
            super((Mob)ent);
            this.ghost = ent;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.ghost.m_21573_().m_26571_()) {
                float f = (float)(this.f_24978_ * this.ghost.m_21133_(Attributes.f_22279_));
                this.ghost.m_7910_(Mth.m_14179_((float)0.125f, (float)this.ghost.m_6113_(), (float)f));
                double d0 = this.f_24975_ - this.ghost.m_20185_();
                double d1 = this.f_24976_ - this.ghost.m_20186_();
                double d2 = this.f_24977_ - this.ghost.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                if (d1 != 0.0) {
                    if (this.ghost.m_5912_()) {
                        this.ghost.m_20256_(this.ghost.m_20184_().m_82520_(0.0, (double)this.ghost.m_6113_() * (d1 / d3) * 0.025, 0.0));
                    } else {
                        this.ghost.m_20256_(this.ghost.m_20184_().m_82520_(0.0, (double)this.ghost.m_6113_() * (d1 / d3) * 0.015, 0.0));
                    }
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.ghost.m_146922_(this.m_24991_(this.ghost.m_146908_(), f1, 90.0f));
                    this.ghost.f_20883_ = this.ghost.m_146908_();
                    if (this.ghost.m_5912_()) {
                        this.ghost.m_20256_(this.ghost.m_20184_().m_82520_((double)this.ghost.m_6113_() * (d0 / d3) * 0.025, 0.0, (double)this.ghost.m_6113_() * (d2 / d3) * 0.025));
                    } else {
                        this.ghost.m_20256_(this.ghost.m_20184_().m_82520_((double)this.ghost.m_6113_() * (d0 / d3) * 0.015, 0.0, (double)this.ghost.m_6113_() * (d2 / d3) * 0.015));
                    }
                }
            } else {
                this.ghost.m_7910_(0.0f);
            }
        }
    }
}

