/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.world.structure;

import com.izofar.bygonenether.init.ModEntityTypes;
import com.izofar.bygonenether.world.structure.util.ModStructureUtils;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import org.jetbrains.annotations.NotNull;

public class PiglinManorStructure
extends StructureFeature<JigsawConfiguration> {
    public static final List<MobSpawnSettings.SpawnerData> MANOR_ENEMIES = List.of(new MobSpawnSettings.SpawnerData(EntityType.f_20511_, 2, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.PIGLIN_HUNTER.get(), 1, 1, 1));

    public PiglinManorStructure(Codec<JigsawConfiguration> codec) {
        super(codec, PiglinManorStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    @NotNull
    private static boolean checkLocation(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        NoiseColumn blockReader = context.f_197352_().m_141914_(blockpos.m_123341_(), blockpos.m_123343_(), context.f_197357_());
        return PiglinManorStructure.checkChunk(context) && !ModStructureUtils.isLavaLake(blockReader) && ModStructureUtils.verticalSpace(blockReader, 34, ModStructureUtils.getScaledNetherHeight(72), 24);
    }

    private static boolean checkChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        return context.f_197358_().test(context.f_197352_().m_203495_(QuartPos.m_175400_((int)context.f_197355_().m_151390_()), QuartPos.m_175400_((int)64), QuartPos.m_175400_((int)context.f_197355_().m_151393_())));
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!PiglinManorStructure.checkLocation(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = ModStructureUtils.getElevation(context, 34, ModStructureUtils.getScaledNetherHeight(72));
        return JigsawPlacement.m_210284_(context, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)false);
    }
}

