/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.minecraftApi;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.gson.AnimationSerializing;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class PlayerAnimationRegistry {
    private static final HashMap<ResourceLocation, KeyframeAnimation> animations = new HashMap();

    @Nullable
    public static KeyframeAnimation getAnimation(@NotNull ResourceLocation identifier) {
        return animations.get(identifier);
    }

    @NotNull
    public static Optional<KeyframeAnimation> getAnimationOptional(@NotNull ResourceLocation identifier) {
        return Optional.ofNullable(PlayerAnimationRegistry.getAnimation(identifier));
    }

    public static Map<ResourceLocation, KeyframeAnimation> getAnimations() {
        return Map.copyOf(animations);
    }

    public static Map<String, KeyframeAnimation> getModAnimations(String modid) {
        HashMap<String, KeyframeAnimation> map = new HashMap<String, KeyframeAnimation>();
        for (Map.Entry<ResourceLocation, KeyframeAnimation> entry : animations.entrySet()) {
            if (!entry.getKey().m_135827_().equals(modid)) continue;
            map.put(entry.getKey().m_135815_(), entry.getValue());
        }
        return map;
    }

    @ApiStatus.Internal
    public static void resourceLoaderCallback(@NotNull ResourceManager manager, Logger logger) {
        animations.clear();
        for (ResourceLocation resource : manager.m_6540_("player_animation", location -> location.endsWith(".json"))) {
            try {
                InputStream input = manager.m_142591_(resource).m_6679_();
                try {
                    for (KeyframeAnimation animation : AnimationSerializing.deserializeAnimation(input)) {
                        animations.put(new ResourceLocation(resource.m_135827_(), PlayerAnimationRegistry.serializeTextToString((String)animation.extraData.get("name")).toLowerCase(Locale.ROOT)), animation);
                    }
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (IOException e) {
                logger.error("Error while loading payer animation: " + resource);
                logger.error(e.getMessage());
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String sStackTrace = sw.toString();
                logger.error(sStackTrace);
            }
        }
    }

    public static String serializeTextToString(String arg) {
        try {
            MutableComponent component = Component.Serializer.m_130701_((String)arg);
            if (component != null) {
                return component.getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arg.replace("\"", "");
    }
}

