/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.Helper;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandLayer.class})
public class HeldItemMixin {
    @Inject(method={"renderArmWithItem"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lcom/mojang/math/Quaternion;)V", ordinal=0)})
    private void renderMixin(LivingEntity livingEntity, ItemStack stack, ItemTransforms.TransformType transformationMode, HumanoidArm arm, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        IAnimatedPlayer player;
        if (Helper.isBendEnabled() && livingEntity instanceof IAnimatedPlayer && (player = (IAnimatedPlayer)livingEntity).getAnimation().isActive()) {
            AnimationApplier anim = player.getAnimation();
            Vec3f data = anim.get3DTransform(arm == HumanoidArm.LEFT ? "leftArm" : "rightArm", TransformType.BEND, new Vec3f(0.0f, 0.0f, 0.0f));
            Pair<Float, Float> pair = new Pair<Float, Float>((Float)data.getX(), (Float)data.getY());
            float offset = 0.25f;
            matrices.m_85837_(0.0, (double)offset, 0.0);
            float bend = pair.getRight().floatValue();
            float axisf = -pair.getLeft().floatValue();
            Vector3f axis = new Vector3f((float)Math.cos(axisf), 0.0f, (float)Math.sin(axisf));
            matrices.m_85845_(axis.m_122270_(bend));
            matrices.m_85837_(0.0, (double)(-offset), 0.0);
        }
    }

    @Inject(method={"renderArmWithItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemInHandRenderer;renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemTransforms$TransformType;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V")})
    private void changeItemLocation(LivingEntity livingEntity, ItemStack itemStack, ItemTransforms.TransformType transformType, HumanoidArm arm, PoseStack matrices, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        IAnimatedPlayer player;
        if (livingEntity instanceof IAnimatedPlayer && (player = (IAnimatedPlayer)livingEntity).getAnimation().isActive()) {
            AnimationApplier anim = player.getAnimation();
            Vec3f rot = anim.get3DTransform(arm == HumanoidArm.LEFT ? "leftItem" : "rightItem", TransformType.ROTATION, Vec3f.ZERO);
            Vec3f pos = anim.get3DTransform(arm == HumanoidArm.LEFT ? "leftItem" : "rightItem", TransformType.POSITION, Vec3f.ZERO).scale(0.0625f);
            matrices.m_85837_((double)((Float)pos.getX()).floatValue(), (double)((Float)pos.getY()).floatValue(), (double)((Float)pos.getZ()).floatValue());
            matrices.m_85845_(Vector3f.f_122227_.m_122270_(((Float)rot.getZ()).floatValue()));
            matrices.m_85845_(Vector3f.f_122225_.m_122270_(((Float)rot.getY()).floatValue()));
            matrices.m_85845_(Vector3f.f_122223_.m_122270_(((Float)rot.getX()).floatValue()));
        }
    }
}

