/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus;

import com.legacy.dungeons_plus.DPConfig;
import com.legacy.dungeons_plus.DungeonsPlus;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.common.util.TriPredicate;
import org.apache.commons.lang3.function.TriFunction;

public class DPUtil {
    public static final Direction[] HORIZONTAL_DIR = (Direction[])Arrays.stream(Direction.values()).filter(d -> d.m_122434_().m_122479_()).toArray(Direction[]::new);

    public static boolean isInEllipsoid(double w, double h, double d, double x, double y, double z) {
        return ((x = w - x / 2.0) - w) * (x - w) / w + ((y = h - y / 2.0) - h) * (y - h) / h + ((z = d - z / 2.0) - d) * (z - d) / d < 1.0;
    }

    public static void fillBlob(ServerLevelAccessor level, BlockPos pos, int range, TriFunction<ServerLevelAccessor, BlockPos, Random, BlockState> stateFunc, Random rand, float chance) {
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos placePos;
                    BlockState state;
                    if (!DPUtil.isInEllipsoid(range, range, range, x, y, z) || !(rand.nextFloat() < chance) || (state = (BlockState)stateFunc.apply((Object)level, (Object)(placePos = pos.m_142082_(x, y, z)), (Object)rand)) == null) continue;
                    level.m_7731_(placePos, state, 2);
                }
            }
        }
    }

    public static void fillBlob(ServerLevelAccessor level, BlockPos pos, int range, BlockState state, TriPredicate<ServerLevelAccessor, BlockPos, BlockState> canPlace, Random rand, float chance) {
        DPUtil.fillBlob(level, pos, range, (TriFunction<ServerLevelAccessor, BlockPos, Random, BlockState>)((TriFunction)(l, p, r) -> canPlace.test(l, p, (Object)l.m_8055_(p)) ? state : null), rand, chance);
    }

    public static BlockPos randOffset(BlockPos pos, int range, Random rand) {
        return pos.m_142082_(DPUtil.range(range, rand), DPUtil.range(range, rand), DPUtil.range(range, rand));
    }

    public static int range(int range, Random rand) {
        return rand.nextInt(range * 2) - range;
    }

    public static void placeWaystone(ServerLevelAccessor level, BlockPos pos, Random rand, @Nullable Block defaultBlock) {
        if (DungeonsPlus.isWaystonesLoaded && rand.nextFloat() < (float)((Integer)DPConfig.COMMON.towerWaystoneChance.get()).intValue()) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            try {
                Feature waystoneFeature = (Feature)level.m_5962_().m_175515_(Registry.f_122838_).m_7745_(new ResourceLocation("waystones", "waystone"));
                if (waystoneFeature != null) {
                    level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
                    WorldGenLevel worldGenRegion = level instanceof WorldGenLevel ? (WorldGenLevel)level : level.m_6018_();
                    waystoneFeature.m_142674_(new FeaturePlaceContext(Optional.empty(), worldGenRegion, level.m_6018_().m_7726_().m_8481_(), rand, pos, (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
                    return;
                }
            }
            catch (Throwable t) {
                DungeonsPlus.LOGGER.error(String.format("Failed to place waystone at (%d, %d, %d)", pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
                DungeonsPlus.LOGGER.error((Object)t);
            }
        }
        level.m_7731_(pos, (defaultBlock != null ? defaultBlock : Blocks.f_50016_).m_49966_(), 2);
    }
}

