/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures.snowy_temple;

import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.GravityProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SnowyTemplePieces {
    private static final ResourceLocation[] BASES = DungeonsPlus.locateAllPrefix("snowy_temple/", "temple_entry");
    private static final ResourceLocation[] FLOORS = DungeonsPlus.locateAllPrefix("snowy_temple/", "temple_room_0", "temple_room_1", "temple_room_2", "temple_room_3", "temple_room_4", "temple_room_5", "temple_room_6", "temple_room_7");
    private static final ResourceLocation[] TOP_FLOORS = DungeonsPlus.locateAllPrefix("snowy_temple/", "temple_top");
    private static final ResourceLocation[] PATHS = DungeonsPlus.locateAllPrefix("snowy_temple/", "path");
    private static final ResourceLocation[] ICE = DungeonsPlus.locateAllPrefix("snowy_temple/", "ice_0", "ice_1", "ice_2");

    public static void assemble(StructureManager structureManager, BlockPos pos, Rotation rotation, StructurePiecesBuilder pieces, Random rand) {
        Direction dir = switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> Direction.NORTH;
            case Rotation.CLOCKWISE_90 -> Direction.EAST;
            case Rotation.CLOCKWISE_180 -> Direction.SOUTH;
            case Rotation.COUNTERCLOCKWISE_90 -> Direction.WEST;
        };
        BlockPos floorPos = pos;
        pieces.m_142679_((StructurePiece)new Piece(structureManager, (ResourceLocation)Util.m_137545_((Object[])BASES, (Random)rand), floorPos, rotation, rand));
        floorPos = floorPos.m_6630_(13);
        int roomHeight = 11;
        boolean flipped = true;
        Rotation flippedRot = rotation.m_55952_(Rotation.CLOCKWISE_180);
        int maxFloors = rand.nextInt(2) + 3;
        ArrayList<ResourceLocation> unusedFloors = new ArrayList<ResourceLocation>(Arrays.asList(FLOORS));
        for (int floor = 0; floor < maxFloors && unusedFloors.size() > 0; ++floor) {
            ResourceLocation floorName = (ResourceLocation)Util.m_143804_(unusedFloors, (Random)rand);
            pieces.m_142679_((StructurePiece)new Piece(structureManager, floorName, floorPos, flipped ? flippedRot : rotation, rand));
            unusedFloors.remove(floorName);
            floorPos = floorPos.m_6630_(roomHeight);
            flipped = !flipped;
        }
        pieces.m_142679_((StructurePiece)new Piece(structureManager, (ResourceLocation)Util.m_137545_((Object[])TOP_FLOORS, (Random)rand), floorPos, rotation, rand));
        pieces.m_142679_((StructurePiece)new Piece(structureManager, (ResourceLocation)Util.m_137545_((Object[])PATHS, (Random)rand), pos.m_142082_(11, 0, 2).m_5484_(dir, 22), rotation, rand));
        pieces.m_142679_((StructurePiece)new Piece(structureManager, (ResourceLocation)Util.m_137545_((Object[])ICE, (Random)rand), pos.m_142082_(11, 0, 11).m_5484_(dir, 16).m_5484_(Rotation.COUNTERCLOCKWISE_90.m_55954_(dir), 8), rotation, rand));
        pieces.m_142679_((StructurePiece)new Piece(structureManager, (ResourceLocation)Util.m_137545_((Object[])ICE, (Random)rand), pos.m_142082_(11, 0, 11).m_5484_(dir, 16).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 8), rotation, rand));
        pieces.m_142679_((StructurePiece)new Piece(structureManager, (ResourceLocation)Util.m_137545_((Object[])ICE, (Random)rand), pos.m_142082_(11, 0, 11).m_5484_(dir, 30).m_5484_(Rotation.COUNTERCLOCKWISE_90.m_55954_(dir), 12), rotation, rand));
        pieces.m_142679_((StructurePiece)new Piece(structureManager, (ResourceLocation)Util.m_137545_((Object[])ICE, (Random)rand), pos.m_142082_(11, 0, 11).m_5484_(dir, 30).m_5484_(Rotation.CLOCKWISE_90.m_55954_(dir), 12), rotation, rand));
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        private static final String DECAY_KEY = "decay";
        private final int decay;

        public Piece(StructureManager structureManager, ResourceLocation location, BlockPos pos, Rotation rotation, Random rand) {
            super(DPStructures.SNOWY_TEMPLE.getPieceType(), 0, structureManager, location, pos);
            this.f_73379_ = rotation;
            this.decay = rand.nextInt(8);
            this.setupPlaceSettings(structureManager);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            super(DPStructures.SNOWY_TEMPLE.getPieceType(), tag, context.f_192764_());
            this.decay = tag.m_128451_(DECAY_KEY);
            this.setupPlaceSettings(context.f_192764_());
        }

        protected void m_183620_(StructurePieceSerializationContext level, CompoundTag tag) {
            super.m_183620_(level, tag);
            tag.m_128405_(DECAY_KEY, this.decay);
        }

        protected StructurePlaceSettings getPlaceSettings(StructureManager structureManager) {
            StructurePlaceSettings settings = new StructurePlaceSettings();
            settings.m_163782_(false);
            Vec3i size = ((StructureTemplate)structureManager.m_163774_(this.m_142415_()).get()).m_163801_();
            settings.m_74385_(new BlockPos(size.m_123341_() / 2, 0, size.m_123343_() / 2));
            if (this.f_163658_.contains("snowy_temple/path") || this.f_163658_.contains("snowy_temple/ice_")) {
                settings.m_74383_((StructureProcessor)new GravityProcessor(Heightmap.Types.WORLD_SURFACE_WG, -1));
            }
            return settings;
        }

        public BlockState modifyState(ServerLevelAccessor level, Random rand, BlockPos pos, BlockState originalState) {
            BlockState air = Blocks.f_50016_.m_49966_();
            BlockState ice = Blocks.f_50126_.m_49966_();
            BlockState packedIce = Blocks.f_50354_.m_49966_();
            if (originalState.m_60713_(Blocks.f_50097_)) {
                return (this.decay & 1) == 1 ? air : ice;
            }
            if (originalState.m_60713_(Blocks.f_50041_)) {
                return (this.decay & 2) == 2 ? air : packedIce;
            }
            if (originalState.m_60713_(Blocks.f_50102_)) {
                return (this.decay & 4) == 4 ? air : packedIce;
            }
            return originalState;
        }

        public void m_7756_(String key, BlockPos pos, ServerLevelAccessor level, Random rand, BoundingBox bounds) {
        }
    }
}

