/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.level;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEventListenerRegistrar;
import net.minecraft.world.level.storage.WritableLevelData;
import team.creative.creativecore.common.level.CreativeLevel;

public abstract class CreativeServerLevel
extends CreativeLevel {
    private final MinecraftServer server;
    final List<ServerPlayer> players = Lists.newArrayList();
    final EntityTickList entityTickList = new EntityTickList();
    private final PersistentEntitySectionManager<Entity> entityManager;
    public boolean noSave;

    protected CreativeServerLevel(MinecraftServer server, WritableLevelData worldInfo, int radius, Supplier<ProfilerFiller> supplier, boolean debug, long seed) {
        super(worldInfo, radius, supplier, false, debug, seed);
        this.server = server;
        this.entityManager = new PersistentEntitySectionManager(Entity.class, (LevelCallback)new EntityCallbacks(), (EntityPersistentStorage)new EntityPersistentStorage<Entity>(){

            public CompletableFuture<ChunkEntities<Entity>> m_141930_(ChunkPos pos) {
                return CompletableFuture.completedFuture(new ChunkEntities(pos, Collections.EMPTY_LIST));
            }

            public void m_141971_(ChunkEntities<Entity> chunk) {
            }

            public void m_182219_(boolean p_182503_) {
            }
        });
    }

    public MinecraftServer m_142572_() {
        return this.server;
    }

    public List<? extends Player> m_6907_() {
        return this.players;
    }

    public Entity m_6815_(int id) {
        return (Entity)this.m_142646_().m_142597_(id);
    }

    public LevelEntityGetter<Entity> m_142646_() {
        return this.entityManager.m_157567_();
    }

    public String m_46464_() {
        return "Chunks[C] W: " + this.getChunkSource().m_6754_() + " E: " + this.entityManager.m_157572_();
    }

    public boolean areEntitiesLoaded(long p_143320_) {
        return this.entityManager.m_157507_(p_143320_);
    }

    public boolean isPositionEntityTicking(BlockPos p_143341_) {
        return this.entityManager.m_202167_(p_143341_);
    }

    public boolean isPositionEntityTicking(ChunkPos p_143276_) {
        return this.entityManager.m_202165_(p_143276_);
    }

    final class EntityCallbacks
    implements LevelCallback<Entity> {
        EntityCallbacks() {
        }

        public void onCreated(Entity p_143355_) {
        }

        public void onDestroyed(Entity p_143359_) {
            CreativeServerLevel.this.m_6188_().m_83420_(p_143359_);
        }

        public void onTickingStart(Entity p_143363_) {
            CreativeServerLevel.this.entityTickList.m_156908_(p_143363_);
        }

        public void onTickingEnd(Entity p_143367_) {
            CreativeServerLevel.this.entityTickList.m_156912_(p_143367_);
        }

        public void onTrackingStart(Entity p_143371_) {
            CreativeServerLevel.this.getChunkSource().addEntity(p_143371_);
        }

        public void onTrackingEnd(Entity p_143375_) {
            CreativeServerLevel.this.getChunkSource().removeEntity(p_143375_);
            GameEventListenerRegistrar gameeventlistenerregistrar = p_143375_.m_146887_();
            if (gameeventlistenerregistrar != null) {
                gameeventlistenerregistrar.m_157854_(p_143375_.f_19853_);
            }
        }
    }
}

