/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.phantasm.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.phantasm.world.features.CrystalCragsFeature;
import net.mcreator.phantasm.world.features.HugePutacShroomFeature;
import net.mcreator.phantasm.world.features.PreamTreeFeature;
import net.mcreator.phantasm.world.features.RawPurpurLayerFeature;
import net.mcreator.phantasm.world.features.StarFeature;
import net.mcreator.phantasm.world.features.TallPreamTreeFeature;
import net.mcreator.phantasm.world.features.VividNihiliumPatchFeature;
import net.mcreator.phantasm.world.features.ores.StelliumOreFeature;
import net.mcreator.phantasm.world.features.plants.CrystalilyFeature;
import net.mcreator.phantasm.world.features.plants.StardustFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class PhantasmModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"phantasm");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> STARDUST = PhantasmModFeatures.register("stardust", StardustFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, StardustFeature.GENERATE_BIOMES, StardustFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CRYSTALILY = PhantasmModFeatures.register("crystalily", CrystalilyFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, CrystalilyFeature.GENERATE_BIOMES, CrystalilyFeature::placedFeature));
    public static final RegistryObject<Feature<?>> STELLIUM_ORE = PhantasmModFeatures.register("stellium_ore", StelliumOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, StelliumOreFeature.GENERATE_BIOMES, StelliumOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> STAR = PhantasmModFeatures.register("star", StarFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, StarFeature.GENERATE_BIOMES, StarFeature::placedFeature));
    public static final RegistryObject<Feature<?>> PREAM_TREE = PhantasmModFeatures.register("pream_tree", PreamTreeFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, PreamTreeFeature.GENERATE_BIOMES, PreamTreeFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RAW_PURPUR_LAYER = PhantasmModFeatures.register("raw_purpur_layer", RawPurpurLayerFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, RawPurpurLayerFeature.GENERATE_BIOMES, RawPurpurLayerFeature::placedFeature));
    public static final RegistryObject<Feature<?>> HUGE_PUTAC_SHROOM = PhantasmModFeatures.register("huge_putac_shroom", HugePutacShroomFeature::feature, new FeatureRegistration(GenerationStep.Decoration.RAW_GENERATION, HugePutacShroomFeature.GENERATE_BIOMES, HugePutacShroomFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CRYSTAL_CRAGS = PhantasmModFeatures.register("crystal_crags", CrystalCragsFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, CrystalCragsFeature.GENERATE_BIOMES, CrystalCragsFeature::placedFeature));
    public static final RegistryObject<Feature<?>> VIVID_NIHILIUM_PATCH = PhantasmModFeatures.register("vivid_nihilium_patch", VividNihiliumPatchFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, VividNihiliumPatchFeature.GENERATE_BIOMES, VividNihiliumPatchFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TALL_PREAM_TREE = PhantasmModFeatures.register("tall_pream_tree", TallPreamTreeFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, TallPreamTreeFeature.GENERATE_BIOMES, TallPreamTreeFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

