/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.model.geo;

import com.github.eterdelta.crittersandcompanions.entity.FerretEntity;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class FerretModel
extends AnimatedGeoModel<FerretEntity> {
    private static final ResourceLocation[] MODELS = new ResourceLocation[]{new ResourceLocation("crittersandcompanions", "geo/ferret.geo.json"), new ResourceLocation("crittersandcompanions", "geo/baby_ferret.geo.json")};
    private static final ResourceLocation[] ADULT_TEXTURES = new ResourceLocation[]{new ResourceLocation("crittersandcompanions", "textures/entity/ferret_1.png"), new ResourceLocation("crittersandcompanions", "textures/entity/ferret_2.png")};
    private static final ResourceLocation[] BABY_TEXTURES = new ResourceLocation[]{new ResourceLocation("crittersandcompanions", "textures/entity/baby_ferret_1.png"), new ResourceLocation("crittersandcompanions", "textures/entity/baby_ferret_2.png")};
    private static final ResourceLocation[] ANIMATIONS = new ResourceLocation[]{new ResourceLocation("crittersandcompanions", "animations/ferret.animation.json"), new ResourceLocation("crittersandcompanions", "animations/baby_ferret.animation.json")};

    public ResourceLocation getModelLocation(FerretEntity object) {
        return MODELS[object.m_6162_() ? 1 : 0];
    }

    public ResourceLocation getTextureLocation(FerretEntity object) {
        return object.m_6162_() ? BABY_TEXTURES[object.getVariant()] : ADULT_TEXTURES[object.getVariant()];
    }

    public ResourceLocation getAnimationFileLocation(FerretEntity animatable) {
        return ANIMATIONS[animatable.m_6162_() ? 1 : 0];
    }

    public void setLivingAnimations(FerretEntity entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (!entity.m_5803_()) {
            IBone neck = this.getAnimationProcessor().getBone("body_2");
            neck.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }
        entity.getFactory().getOrCreateAnimationData(uniqueID).setResetSpeedInTicks(4.0);
    }
}

