/*
 * Decompiled with CFR 0.152.
 */
package dev.nerdthings.expandedcaves.common.blocks;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;

public class BreakingBlock
extends Block {
    public static final BooleanProperty TRIGGERED = BooleanProperty.m_61465_((String)"triggered");
    public static final IntegerProperty DAMAGE_PHASE = IntegerProperty.m_61631_((String)"damage_phase", (int)0, (int)2);
    private final SoundEvent crackSoundEvent;
    private final ForgeConfigSpec.BooleanValue enabled;

    public BreakingBlock(SoundEvent crackSoundEvent, ForgeConfigSpec.BooleanValue enabled, BlockBehaviour.Properties properties) {
        super(properties);
        this.crackSoundEvent = crackSoundEvent;
        this.enabled = enabled;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)TRIGGERED, (Comparable)Boolean.FALSE)).m_61124_((Property)DAMAGE_PHASE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{TRIGGERED, DAMAGE_PHASE});
    }

    public void m_7458_(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        if (((Boolean)pState.m_61143_((Property)TRIGGERED)).booleanValue()) {
            int currentPhase = (Integer)pState.m_61143_((Property)DAMAGE_PHASE);
            if (currentPhase > 0) {
                for (Direction offset : Direction.values()) {
                    BlockPos neighbourPos = pPos.m_142300_(offset);
                    BlockState neighbour = pLevel.m_8055_(neighbourPos);
                    Block block = neighbour.m_60734_();
                    if (!(block instanceof BreakingBlock)) continue;
                    BreakingBlock breakingBlock = (BreakingBlock)block;
                    breakingBlock.playTriggerEffects((Level)pLevel, neighbourPos, neighbour, pRandom);
                    pLevel.m_7731_(neighbourPos, (BlockState)((BlockState)neighbour.m_61124_((Property)DAMAGE_PHASE, (Comparable)Integer.valueOf(currentPhase - 1))).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
            switch (currentPhase) {
                case 0: {
                    pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)DAMAGE_PHASE, (Comparable)Integer.valueOf(1))).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
                    break;
                }
                case 1: {
                    pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)DAMAGE_PHASE, (Comparable)Integer.valueOf(2))).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
                    break;
                }
                case 2: {
                    pLevel.m_46961_(pPos, false);
                }
            }
        }
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (((Boolean)this.enabled.get()).booleanValue() && pEntity.m_6095_() == EntityType.f_20532_ && !((Boolean)pState.m_61143_((Property)TRIGGERED)).booleanValue() && pLevel.m_5822_().nextFloat() > 0.66f) {
            this.playTriggerEffects(pLevel, pPos, pState, pLevel.m_5822_());
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
            if ((Integer)pState.m_61143_((Property)DAMAGE_PHASE) < 2) {
                this.scheduleTick(pLevel, pPos, pLevel.m_5822_());
            } else {
                pLevel.m_186460_(pPos, (Block)this, 0);
            }
        }
    }

    private void playTriggerEffects(Level pLevel, BlockPos pPos, BlockState pState, Random pRandom) {
        pLevel.m_5594_(null, pPos, this.crackSoundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        for (int i = 0; i < 8; ++i) {
            pLevel.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, pState), (double)((float)pPos.m_123341_() + 0.5f), (double)((float)pPos.m_123342_() + 1.5f), (double)((float)pPos.m_123343_() + 0.5f), (double)pRandom.nextFloat(-0.5f, 0.5f), (double)(1.5f + pRandom.nextFloat()), (double)pRandom.nextFloat(-0.5f, 0.5f));
        }
    }

    private void scheduleTick(Level pLevel, BlockPos pPos, Random pRandom) {
        pLevel.m_186460_(pPos, (Block)this, Math.round((0.2f + 1.0f * pRandom.nextFloat()) * 20.0f));
    }
}

