/*
 * Decompiled with CFR 0.152.
 */
package dev.nerdthings.expandedcaves.common.blocks;

import dev.nerdthings.expandedcaves.ECaveMod;
import dev.nerdthings.expandedcaves.common.blocks.BreakingBlock;
import dev.nerdthings.expandedcaves.common.blocks.moss.MossBlock;
import dev.nerdthings.expandedcaves.common.blocks.moss.MossType;
import dev.nerdthings.expandedcaves.common.blocks.mushroom.CustomMushroom;
import dev.nerdthings.expandedcaves.common.blocks.mushroom.CustomMushroomBlock;
import dev.nerdthings.expandedcaves.common.blocks.pots.PotBlock;
import dev.nerdthings.expandedcaves.common.blocks.pots.PotType;
import dev.nerdthings.expandedcaves.common.blocks.rock.DecorativeRockBlock;
import dev.nerdthings.expandedcaves.common.blocks.rock.RockpileBlock;
import dev.nerdthings.expandedcaves.common.blocks.spelothem.SpelothemBundle;
import dev.nerdthings.expandedcaves.common.blocks.vine.CaveVineBlock;
import dev.nerdthings.expandedcaves.common.blocks.vine.CaveVineEndBlock;
import dev.nerdthings.expandedcaves.common.config.ECaveConfig;
import dev.nerdthings.expandedcaves.common.items.ModFoods;
import dev.nerdthings.expandedcaves.common.items.ModItems;
import dev.nerdthings.expandedcaves.common.items.PebbleItem;
import dev.nerdthings.expandedcaves.common.tag.ModTags;
import dev.nerdthings.extendedcaves.repack.registrate.Registrate;
import dev.nerdthings.extendedcaves.repack.registrate.builders.BlockBuilder;
import dev.nerdthings.extendedcaves.repack.registrate.providers.RegistrateRecipeProvider;
import dev.nerdthings.extendedcaves.repack.registrate.providers.loot.RegistrateBlockLootTables;
import dev.nerdthings.extendedcaves.repack.registrate.util.DataIngredient;
import dev.nerdthings.extendedcaves.repack.registrate.util.entry.BlockEntry;
import dev.nerdthings.extendedcaves.repack.registrate.util.nullness.NonNullFunction;
import dev.nerdthings.extendedcaves.repack.registrate.util.nullness.NonNullSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StoneButtonBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    private static final Registrate REGISTRATE = ECaveMod.registrate();
    public static BlockEntry<CustomMushroomBlock> SWEETSHROOM = ModBlocks.mushroom("sweetshroom", "Sweetshroom", CustomMushroom.SWEETSHROOM, ModFoods.SWEETSHROOM).register();
    public static BlockEntry<CustomMushroomBlock> GOLDISHROOM = ModBlocks.mushroom("goldishroom", "Goldishroom", CustomMushroom.GOLDISHROOM, ModFoods.GOLDISHROOM).register();
    public static BlockEntry<CustomMushroomBlock> SHINYSHROOM = ModBlocks.mushroom("shinyshroom", "Shinyshroom", CustomMushroom.SHINYSHROOM, ModFoods.SHINYSHROOM).register();
    public static BlockEntry<CustomMushroomBlock> LUMISHROOM = ModBlocks.mushroom("lumishroom", "Lumishroom", CustomMushroom.LUMISHROOM, ModFoods.LUMISHROOM).properties(props -> props.m_60953_(state -> 9)).register();
    public static BlockEntry<CustomMushroomBlock> FLUOSHROOM = ModBlocks.mushroom("fluoshroom", "Fluoshroom", CustomMushroom.FLUOSHROOM, ModFoods.FLUOSHROOM).properties(props -> props.m_60953_(state -> 8)).register();
    public static BlockEntry<CustomMushroomBlock> ROCKSHROOM = ModBlocks.mushroom("rockshroom", "Rockshroom", CustomMushroom.ROCKSHROOM, ModFoods.ROCKSHROOM).register();
    public static final BlockEntry<MossBlock> MOSS_DRY = ModBlocks.moss("dry_moss", MossType.DRY).loot((t, b) -> t.m_124165_((Block)b, RegistrateBlockLootTables.createShearsDispatchTable(b, ((LootPoolSingletonContainer.Builder)RegistrateBlockLootTables.applyExplosionDecay((ItemLike)b, LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PLANT_FIBER.get())))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))))).register();
    public static final BlockEntry<MossBlock> MOSS_FIRE = ModBlocks.moss("fire_moss", MossType.FIRE).properties(props -> props.m_60953_(state -> 12)).loot(BlockLoot::m_124272_).register();
    public static final BlockEntry<MossBlock> MOSS_FROZEN = ModBlocks.moss("frozen_moss", MossType.FROZEN).loot(BlockLoot::m_124272_).register();
    public static final BlockEntry<MossBlock> MOSS_HANGING_ROOTS = ModBlocks.moss("hanging_roots", MossType.HANGING_ROOTS).loot(BlockLoot::m_124272_).register();
    public static final BlockEntry<MossBlock> MOSS_HUMID_GROUND = ModBlocks.moss("humid_moss_ground", MossType.HUMID_GROUND).lang("Humid Moss").loot(BlockLoot::m_124272_).register();
    public static final BlockEntry<MossBlock> MOSS_HUMID_CEILING = ModBlocks.moss("humid_moss_ceiling", MossType.HUMID_CEILING).lang("Humid Moss").loot(BlockLoot::m_124272_).register();
    public static final BlockEntry<CaveVineBlock> CAVE_VINE = ModBlocks.vine("cave_vine", CaveVineBlock::new).properties(props -> props.m_60910_().m_60966_().m_60918_(SoundType.f_56740_)).lang("Cave Vine").register();
    public static final BlockEntry<CaveVineEndBlock> CAVE_VINE_END = ((BlockBuilder)ModBlocks.vine("cave_vine_end", CaveVineEndBlock::new).properties(props -> props.m_60977_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_)).lang("Cave Vine").item().tab(() -> ECaveMod.TAB).model((ctx, prov) -> prov.generated((NonNullSupplier<? extends ItemLike>)ctx, ECaveMod.loc("block/cave_vine_end"))).build()).register();
    public static final BlockEntry<BreakingBlock> BROKEN_STONE = ((BlockBuilder)REGISTRATE.block("broken_stone", Material.f_76278_, properties -> new BreakingBlock(SoundEvents.f_12442_, ECaveConfig.COMMON.ORE_BROKEN_STONE.ENABLED, (BlockBehaviour.Properties)properties)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(new ResourceLocation("block/stone")))).properties(props -> props.m_60913_(0.75f, 1.5f)).tag(BlockTags.f_144282_).loot((loot, block) -> loot.m_124165_((Block)block, RegistrateBlockLootTables.createSingleItemTableWithSilkTouch(block, (ItemLike)Blocks.f_50652_))).item().tab(() -> ECaveMod.TAB).build()).register();
    public static final BlockEntry<BreakingBlock> BROKEN_DEEPSLATE = ((BlockBuilder)REGISTRATE.block("broken_deepslate", Material.f_76278_, properties -> new BreakingBlock(SoundEvents.f_144108_, ECaveConfig.COMMON.ORE_BROKEN_DEEPSLATE.ENABLED, (BlockBehaviour.Properties)properties)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(new ResourceLocation("block/deepslate")))).properties(props -> props.m_60913_(0.75f, 1.5f).m_60918_(SoundType.f_154677_)).tag(BlockTags.f_144282_).loot((loot, block) -> loot.m_124165_((Block)block, RegistrateBlockLootTables.createSingleItemTableWithSilkTouch(block, (ItemLike)Blocks.f_50652_))).item().tab(() -> ECaveMod.TAB).build()).register();
    public static final BlockEntry<Block> SEDIMENT_STONE = ModBlocks.stoneBlock("sediment_stone").properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Sediment Stone").register();
    public static final BlockEntry<StairBlock> SEDIMENT_STONE_STAIRS = ModBlocks.stairBlock("sediment_stone", SEDIMENT_STONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Sediment Stone Stairs").register();
    public static final BlockEntry<SlabBlock> SEDIMENT_STONE_SLAB = ModBlocks.slabBlock("sediment_stone", SEDIMENT_STONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Sediment Stone Slab").register();
    public static final BlockEntry<StoneButtonBlock> SEDIMENT_STONE_BUTTON = ModBlocks.buttonBlock("sediment_stone", SEDIMENT_STONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Sediment Stone Button").register();
    public static final BlockEntry<PressurePlateBlock> SEDIMENT_STONE_PRESSURE_PLATE = ModBlocks.pressurePlateBlock("sediment_stone", SEDIMENT_STONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Sediment Stone Pressure Plate").register();
    public static final BlockEntry<WallBlock> SEDIMENT_STONE_WALL = ModBlocks.wallBlock("sediment_stone", SEDIMENT_STONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Sediment Stone Wall").register();
    public static final BlockEntry<Block> LAVASTONE = ModBlocks.stoneBlock("lavastone").properties(props -> props.m_60913_(2.0f, 8.0f)).tag(BlockTags.f_144282_).register();
    public static final BlockEntry<StairBlock> LAVASTONE_STAIRS = ModBlocks.stairBlock("lavastone", LAVASTONE).properties(props -> props.m_60913_(2.0f, 8.0f)).tag(BlockTags.f_144282_).register();
    public static final BlockEntry<SlabBlock> LAVASTONE_SLAB = ModBlocks.slabBlock("lavastone", LAVASTONE).properties(props -> props.m_60913_(2.0f, 8.0f)).tag(BlockTags.f_144282_).register();
    public static final BlockEntry<StoneButtonBlock> LAVASTONE_BUTTON = ModBlocks.buttonBlock("lavastone", LAVASTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Lavastone Button").register();
    public static final BlockEntry<PressurePlateBlock> LAVASTONE_PRESSURE_PLATE = ModBlocks.pressurePlateBlock("lavastone", LAVASTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Lavastone Pressure Plate").register();
    public static final BlockEntry<WallBlock> LAVASTONE_WALL = ModBlocks.wallBlock("lavastone", LAVASTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Lavastone Wall").register();
    public static final BlockEntry<Block> POLISHED_LAVASTONE = ModBlocks.stoneBlock("polished_lavastone").properties(props -> props.m_60913_(2.0f, 8.0f)).tag(BlockTags.f_144282_).recipe((ctx, prov) -> {
        DataIngredient ingredient = DataIngredient.items(LAVASTONE, new NonNullSupplier[0]);
        prov.stonecutting(ingredient, ctx);
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)4).m_126130_("XX").m_126130_("XX").m_126124_(Character.valueOf('X'), (Ingredient)ingredient).m_142284_("has_" + prov.safeName(ingredient), (CriterionTriggerInstance)ingredient.getCritereon((RegistrateRecipeProvider)prov)).m_142700_((Consumer)prov, prov.safeId((IForgeRegistryEntry<?>)ctx.get()));
    }).register();
    public static final BlockEntry<StairBlock> POLISHED_LAVASTONE_STAIRS = ModBlocks.stairBlock("polished_lavastone", POLISHED_LAVASTONE).properties(props -> props.m_60913_(2.0f, 8.0f)).tag(BlockTags.f_144282_).register();
    public static final BlockEntry<SlabBlock> POLISHED_LAVASTONE_SLAB = ModBlocks.slabBlock("polished_lavastone", POLISHED_LAVASTONE).properties(props -> props.m_60913_(2.0f, 8.0f)).tag(BlockTags.f_144282_).register();
    public static final BlockEntry<StoneButtonBlock> POLISHED_LAVASTONE_BUTTON = ModBlocks.buttonBlock("polished_lavastone", POLISHED_LAVASTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Polished Lavastone Button").register();
    public static final BlockEntry<PressurePlateBlock> POLISHED_LAVASTONE_PRESSURE_PLATE = ModBlocks.pressurePlateBlock("polished_lavastone", POLISHED_LAVASTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Polished Lavastone Pressure Plate").register();
    public static final BlockEntry<WallBlock> POLISHED_LAVASTONE_WALL = ModBlocks.wallBlock("polished_lavastone", POLISHED_LAVASTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Polished Lavastone Wall").register();
    public static final BlockEntry<Block> DIRTSTONE = ModBlocks.stoneBlock("dirtstone").properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).register();
    public static final BlockEntry<StairBlock> DIRTSTONE_STAIRS = ModBlocks.stairBlock("dirtstone", DIRTSTONE).properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).register();
    public static final BlockEntry<SlabBlock> DIRTSTONE_SLAB = ModBlocks.slabBlock("dirtstone", DIRTSTONE).properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).register();
    public static final BlockEntry<StoneButtonBlock> DIRTSTONE_BUTTON = ModBlocks.buttonBlock("dirtstone", DIRTSTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Dirtstone Button").register();
    public static final BlockEntry<PressurePlateBlock> DIRTSTONE_PRESSURE_PLATE = ModBlocks.pressurePlateBlock("dirtstone", DIRTSTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Dirtstone Pressure Plate").register();
    public static final BlockEntry<WallBlock> DIRTSTONE_WALL = ModBlocks.wallBlock("dirtstone", DIRTSTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Dirtstone Wall").register();
    public static final BlockEntry<Block> COBBLED_DIRTSTONE = ModBlocks.stoneBlock("dirtstone_cobble").properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).lang("Cobbled Dirtstone").register();
    public static final BlockEntry<StairBlock> COBBLED_DIRTSTONE_STAIRS = ModBlocks.stairBlock("dirtstone_cobble", COBBLED_DIRTSTONE).properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).lang("Cobbled Dirtstone Stairs").recipe((ctx, prov) -> prov.stairs(DataIngredient.items((ItemLike)((Block)COBBLED_DIRTSTONE.get()), (ItemLike[])new Block[0]), ctx, (String)null, true)).register();
    public static final BlockEntry<SlabBlock> COBBLED_DIRTSTONE_SLAB = ModBlocks.slabBlock("dirtstone_cobble", COBBLED_DIRTSTONE).properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).lang("Cobbled Dirtstone Slab").recipe((ctx, prov) -> prov.slab(DataIngredient.items((ItemLike)((Block)COBBLED_DIRTSTONE.get()), (ItemLike[])new Block[0]), ctx, (String)null, true)).register();
    public static final BlockEntry<StoneButtonBlock> COBBLED_DIRTSTONE_BUTTON = ModBlocks.buttonBlock("dirtstone_cobble", COBBLED_DIRTSTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Cobbled Dirtstone Button").register();
    public static final BlockEntry<PressurePlateBlock> COBBLED_DIRTSTONE_PRESSURE_PLATE = ModBlocks.pressurePlateBlock("dirtstone_cobble", COBBLED_DIRTSTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Cobbled Dirtstone Pressure Plate").register();
    public static final BlockEntry<WallBlock> COBBLED_DIRTSTONE_WALL = ModBlocks.wallBlock("dirtstone_cobble", COBBLED_DIRTSTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Cobbled Dirtstone Wall").register();
    public static final BlockEntry<Block> MARLSTONE = ((BlockBuilder)REGISTRATE.block("marlstone", Material.f_76278_, Block::new).properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).loot((loot, block) -> loot.m_124165_((Block)block, RegistrateBlockLootTables.createSingleItemTableWithSilkTouch(block, (ItemLike)MARLSTONE_POWDER.get()))).item().tab(() -> ECaveMod.TAB).build()).register();
    public static final BlockEntry<StoneButtonBlock> MARLSTONE_BUTTON = ModBlocks.buttonBlock("marlstone", MARLSTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Marlstone Button").register();
    public static final BlockEntry<PressurePlateBlock> MARLSTONE_PRESSURE_PLATE = ModBlocks.pressurePlateBlock("marlstone", MARLSTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Marlstone Pressure Plate").register();
    public static final BlockEntry<WallBlock> MARLSTONE_WALL = ModBlocks.wallBlock("marlstone", MARLSTONE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Marlstone Wall").register();
    public static final BlockEntry<SandBlock> MARLSTONE_POWDER = ((BlockBuilder)REGISTRATE.block("marlstone_powder", Material.f_76317_, props -> new SandBlock(6901053, props)).properties(props -> props.m_60978_(0.5f).m_60918_(SoundType.f_56746_)).tag(BlockTags.f_144283_).recipe((ctx, prov) -> {
        DataIngredient powder = DataIngredient.items(ctx, new NonNullSupplier[0]);
        ShapedRecipeBuilder.m_126118_((ItemLike)Items.f_41983_, (int)8).m_126130_("PPP").m_126130_("PWP").m_126130_("PPP").m_126124_(Character.valueOf('P'), (Ingredient)powder).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_42447_).m_142284_("has_" + prov.safeName(powder), (CriterionTriggerInstance)powder.getCritereon((RegistrateRecipeProvider)prov)).m_142700_((Consumer)prov, prov.safeId((IForgeRegistryEntry<?>)Items.f_41983_));
    }).item().tab(() -> ECaveMod.TAB).build()).register();
    public static final BlockEntry<Block> BRICKS_ICE = ModBlocks.dumbBlock("bricks_ice").properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).lang("Ice Bricks").register();
    public static final BlockEntry<StairBlock> BRICKS_ICE_STAIRS = ModBlocks.stairBlock("bricks_ice", BRICKS_ICE).properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).lang("Ice Brick Stairs").recipe((ctx, prov) -> prov.stairs(DataIngredient.items((ItemLike)((Block)BRICKS_ICE.get()), (ItemLike[])new Block[0]), ctx, (String)null, true)).register();
    public static final BlockEntry<SlabBlock> BRICKS_ICE_SLAB = ModBlocks.slabBlock("bricks_ice", BRICKS_ICE).properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).lang("Ice Brick Slab").recipe((ctx, prov) -> prov.slab(DataIngredient.items((ItemLike)((Block)BRICKS_ICE.get()), (ItemLike[])new Block[0]), ctx, (String)null, true)).register();
    public static final BlockEntry<StoneButtonBlock> BRICKS_ICE_BUTTON = ModBlocks.buttonBlock("bricks_ice", BRICKS_ICE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Ice Bricks Button").register();
    public static final BlockEntry<PressurePlateBlock> BRICKS_ICE_PRESSURE_PLATE = ModBlocks.pressurePlateBlock("bricks_ice", BRICKS_ICE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Ice Bricks Pressure Plate").register();
    public static final BlockEntry<WallBlock> BRICKS_ICE_WALL = ModBlocks.wallBlock("bricks_ice", BRICKS_ICE).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Ice Bricks Wall").register();
    public static final BlockEntry<Block> BRICKS_SNOW = ModBlocks.dumbBlock("bricks_snow").properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).lang("Snow Bricks").register();
    public static final BlockEntry<StairBlock> BRICKS_SNOW_STAIRS = ModBlocks.stairBlock("bricks_snow", BRICKS_SNOW).properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).lang("Snow Brick Stairs").recipe((ctx, prov) -> prov.stairs(DataIngredient.items((ItemLike)((Block)BRICKS_SNOW.get()), (ItemLike[])new Block[0]), ctx, (String)null, true)).register();
    public static final BlockEntry<SlabBlock> BRICKS_SNOW_SLAB = ModBlocks.slabBlock("bricks_snow", BRICKS_SNOW).properties(props -> props.m_60913_(1.2f, 3.0f)).tag(BlockTags.f_144282_).lang("Snow Brick Slab").register();
    public static final BlockEntry<StoneButtonBlock> BRICKS_SNOW_BUTTON = ModBlocks.buttonBlock("bricks_snow", BRICKS_SNOW).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Snow Bricks Button").register();
    public static final BlockEntry<PressurePlateBlock> BRICKS_SNOW_PRESSURE_PLATE = ModBlocks.pressurePlateBlock("bricks_snow", BRICKS_SNOW).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Snow Bricks Pressure Plate").register();
    public static final BlockEntry<WallBlock> BRICKS_SNOW_WALL = ModBlocks.wallBlock("bricks_snow", BRICKS_SNOW).properties(props -> props.m_60913_(1.0f, 3.0f)).tag(BlockTags.f_144282_).lang("Snow Bricks Wall").register();
    public static final BlockEntry<DecorativeRockBlock> PEBBLE_FLINT = ((BlockBuilder)REGISTRATE.block("rock_flint", Material.f_76278_, props -> new DecorativeRockBlock(DecorativeRockBlock.FLINT_SHAPE, (BlockBehaviour.Properties)props)).properties(props -> props.m_60966_().m_60988_()).lang("Flint Pebble").blockstate((ctx, prov) -> {
        ModelFile.ExistingModelFile model = prov.models().getExistingFile(ECaveMod.loc("block/rock_flint"));
        prov.getVariantBuilder((Block)ctx.get()).partialState().modelForState().modelFile((ModelFile)model).nextModel().modelFile((ModelFile)model).rotationY(90).nextModel().modelFile((ModelFile)model).rotationY(180).nextModel().modelFile((ModelFile)model).rotationY(270).addModel();
    }).loot((t, b) -> t.m_124165_((Block)b, RegistrateBlockLootTables.createSilkTouchDispatchTable(b, (LootPoolEntryContainer.Builder)RegistrateBlockLootTables.applyExplosionDecay((ItemLike)b, LootItem.m_79579_((ItemLike)Items.f_42484_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))))).item().model((ctx, prov) -> prov.getExistingFile(ECaveMod.loc("item/rock_flint"))).tab(() -> ECaveMod.TAB).build()).register();
    public static final BlockEntry<RockpileBlock> STONE_PEBBLES = ModBlocks.pileBlock("stone_pebble", new ResourceLocation("block/stone"), () -> Blocks.f_50069_).register();
    public static final BlockEntry<RockpileBlock> ANDESITE_PEBBLES = ModBlocks.pileBlock("andesite_pebble", new ResourceLocation("block/andesite"), () -> Blocks.f_50334_).register();
    public static final BlockEntry<RockpileBlock> DIORITE_PEBBLES = ModBlocks.pileBlock("diorite_pebble", new ResourceLocation("block/diorite"), () -> Blocks.f_50228_).register();
    public static final BlockEntry<RockpileBlock> GRANITE_PEBBLES = ModBlocks.pileBlock("granite_pebble", new ResourceLocation("block/granite"), () -> Blocks.f_50122_).register();
    public static final BlockEntry<RockpileBlock> TUFF_PEBBLES = ModBlocks.pileBlock("tuff_pebble", new ResourceLocation("block/tuff"), () -> Blocks.f_152496_).properties(props -> props.m_60918_(SoundType.f_154659_)).register();
    public static final BlockEntry<RockpileBlock> DEEPSLATE_PEBBLES = ModBlocks.pileBlock("deepslate_pebble", new ResourceLocation("block/deepslate"), () -> Blocks.f_152550_).properties(props -> props.m_60918_(SoundType.f_154677_)).register();
    public static final BlockEntry<RockpileBlock> SEDIMENT_STONE_PEBBLES = ModBlocks.pileBlock("sediment_stone_pebble", ECaveMod.loc("block/sediment_stone"), SEDIMENT_STONE).register();
    public static final BlockEntry<RockpileBlock> LAVASTONE_PEBBLES = ModBlocks.pileBlock("lavastone_pebble", ECaveMod.loc("block/lavastone"), LAVASTONE).register();
    public static final BlockEntry<RockpileBlock> NETHERRACK_PEBBLES = ModBlocks.pileBlock("netherrack_pebble", new ResourceLocation("block/netherrack"), () -> Blocks.f_50134_, true).register();
    public static final BlockEntry<RockpileBlock> BLACKSTONE_PEBBLES = ModBlocks.pileBlock("blackstone_pebble", new ResourceLocation("block/blackstone"), () -> Blocks.f_50730_, true).register();
    public static final SpelothemBundle STONE_SPELOTHEMS = new SpelothemBundle(REGISTRATE, "stone", "Stone", Material.f_76278_, 0.45f, 0.75f, new ResourceLocation("block/stone"), STONE_PEBBLES);
    public static final SpelothemBundle ANDESITE_SPELOTHEMS = new SpelothemBundle(REGISTRATE, "andesite", "Andesite", Material.f_76278_, 0.45f, 0.75f, new ResourceLocation("block/andesite"), ANDESITE_PEBBLES);
    public static final SpelothemBundle DIORITE_SPELOTHEMS = new SpelothemBundle(REGISTRATE, "diorite", "Diorite", Material.f_76278_, 0.45f, 0.75f, new ResourceLocation("block/diorite"), DIORITE_PEBBLES);
    public static final SpelothemBundle GRANITE_SPELOTHEMS = new SpelothemBundle(REGISTRATE, "granite", "Granite", Material.f_76278_, 0.45f, 0.75f, new ResourceLocation("block/granite"), GRANITE_PEBBLES);
    public static final SpelothemBundle TUFF_SPELOTHEMS = new SpelothemBundle(REGISTRATE, "tuff", "Tuff", Material.f_76278_, 0.45f, 0.75f, new ResourceLocation("block/tuff"), TUFF_PEBBLES);
    public static final SpelothemBundle DEEPSLATE_SPELOTHEMS = new SpelothemBundle(REGISTRATE, "deepslate", "Deepslate", Material.f_76278_, 0.45f, 0.75f, new ResourceLocation("block/deepslate"), DEEPSLATE_PEBBLES, props -> props.m_60918_(SoundType.f_154677_));
    public static final SpelothemBundle SEDIMENT_STONE_SPELOTHEMS = new SpelothemBundle(REGISTRATE, "sediment_stone", "Sediment Stone", Material.f_76278_, 0.3f, 0.6f, ECaveMod.loc("block/sediment_stone"), SEDIMENT_STONE_PEBBLES);
    public static final SpelothemBundle LAVASTONE_SPELOTHEMS = new SpelothemBundle(REGISTRATE, "lavastone", "Lavastone", Material.f_76278_, 0.6f, 1.0f, ECaveMod.loc("block/lavastone"), LAVASTONE_PEBBLES);
    public static final SpelothemBundle PACKED_ICE_SPELOTHEMS = new SpelothemBundle(REGISTRATE, "packed_ice", "Packed Ice", Material.f_76276_, 0.15f, 0.25f, new ResourceLocation("block/packed_ice"), null, props -> props.m_60911_(0.98f).m_60918_(SoundType.f_56744_));
    public static final SpelothemBundle NETHERRACK_SPELOTHEMS = new SpelothemBundle(REGISTRATE, "netherrack", "Netherrack", Material.f_76278_, 0.15f, 0.25f, new ResourceLocation("block/netherrack"), null, props -> props.m_60918_(SoundType.f_56720_));
    public static final SpelothemBundle BLACKSTONE_SPELOTHEMS = new SpelothemBundle(REGISTRATE, "blackstone", "Blackstone", Material.f_76278_, 0.15f, 0.25f, new ResourceLocation("block/blackstone"), null);
    public static final BlockEntry<PotBlock> TREASURE_POT = ModBlocks.pot("treasure_pot", PotType.TREASURE_NORMAL).loot((t, b) -> t.m_124165_((Block)b, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42619_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42620_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42410_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))))))).register();
    public static final BlockEntry<PotBlock> SMALL_TREASURE_POT = ModBlocks.pot("small_treasure_pot", PotType.TREASURE_SHORT).loot((t, b) -> t.m_124165_((Block)b, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42401_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42403_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))))).register();
    public static final BlockEntry<PotBlock> TREASURE_AMPHORA = ModBlocks.pot("treasure_amphora", PotType.TREASURE_LONG).loot((t, b) -> t.m_124165_((Block)b, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42500_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))))).register();
    public static final BlockEntry<PotBlock> SMALL_QUARTZ_TREASURE_POT = ModBlocks.pot("small_quartz_treasure_pot", PotType.TREASURE_QUARTZ_SHORT).loot((t, b) -> t.m_124165_((Block)b, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42677_).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.1f))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42436_).m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.1f))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))))))).register();
    public static final BlockEntry<PotBlock> QUARTZ_TREASURE_AMPHORA = ModBlocks.pot("quartz_treasure_amphora", PotType.TREASURE_QUARTZ_LONG).loot((t, b) -> t.m_124165_((Block)b, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42412_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42000_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))))).register();
    public static final BlockEntry<PotBlock> DECORATIVE_POT = ModBlocks.pot("decorative_pot", PotType.DECORATIVE_NORMAL).recipe((ctx, prov) -> {
        DataIngredient brick = DataIngredient.items(ModItems.BRICK_HALF, new NonNullSupplier[0]);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_(" B ").m_126130_("B B").m_126130_(" B ").m_126124_(Character.valueOf('B'), (Ingredient)brick).m_142284_("has_" + prov.safeName(brick), (CriterionTriggerInstance)brick.getCritereon((RegistrateRecipeProvider)prov)).m_142700_((Consumer)prov, prov.safeId((IForgeRegistryEntry<?>)ctx.get()));
    }).register();
    public static final BlockEntry<PotBlock> SMALL_DECORATIVE_POT = ModBlocks.pot("small_decorative_pot", PotType.DECORATIVE_SHORT).recipe((ctx, prov) -> {
        DataIngredient brick = DataIngredient.items(ModItems.BRICK_HALF, new NonNullSupplier[0]);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("B B").m_126130_(" B ").m_126124_(Character.valueOf('B'), (Ingredient)brick).m_142284_("has_" + prov.safeName(brick), (CriterionTriggerInstance)brick.getCritereon((RegistrateRecipeProvider)prov)).m_142700_((Consumer)prov, prov.safeId((IForgeRegistryEntry<?>)ctx.get()));
    }).register();
    public static final BlockEntry<PotBlock> DECORATIVE_AMPHORA = ModBlocks.pot("decorative_amphora", PotType.DECORATIVE_LONG).recipe((ctx, prov) -> {
        DataIngredient brick = DataIngredient.items(ModItems.BRICK_HALF, new NonNullSupplier[0]);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("B B").m_126130_("B B").m_126130_(" B ").m_126124_(Character.valueOf('B'), (Ingredient)brick).m_142284_("has_" + prov.safeName(brick), (CriterionTriggerInstance)brick.getCritereon((RegistrateRecipeProvider)prov)).m_142700_((Consumer)prov, prov.safeId((IForgeRegistryEntry<?>)ctx.get()));
    }).register();
    public static final BlockEntry<PotBlock> SMALL_DECORATIVE_QUARTZ_POT = ModBlocks.pot("small_decorative_quartz_pot", PotType.DECORATIVE_QUARTZ_SHORT).recipe((ctx, prov) -> {
        DataIngredient quartz = DataIngredient.items((ItemLike)Items.f_42692_, (ItemLike[])new Item[0]);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("Q Q").m_126130_(" Q ").m_126124_(Character.valueOf('Q'), (Ingredient)quartz).m_142284_("has_" + prov.safeName(quartz), (CriterionTriggerInstance)quartz.getCritereon((RegistrateRecipeProvider)prov)).m_142700_((Consumer)prov, prov.safeId((IForgeRegistryEntry<?>)ctx.get()));
    }).register();
    public static final BlockEntry<PotBlock> DECORATIVE_QUARTZ_AMPHORA = ModBlocks.pot("decorative_quartz_amphora", PotType.DECORATIVE_QUARTZ_LONG).recipe((ctx, prov) -> {
        DataIngredient quartz = DataIngredient.items((ItemLike)Items.f_42692_, (ItemLike[])new Item[0]);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("Q Q").m_126130_("Q Q").m_126130_(" Q ").m_126124_(Character.valueOf('Q'), (Ingredient)quartz).m_142284_("has_" + prov.safeName(quartz), (CriterionTriggerInstance)quartz.getCritereon((RegistrateRecipeProvider)prov)).m_142700_((Consumer)prov, prov.safeId((IForgeRegistryEntry<?>)ctx.get()));
    }).register();

    private static BlockBuilder<CustomMushroomBlock, Registrate> mushroom(String name, String localized, CustomMushroom mushroom, FoodProperties food) {
        ResourceLocation tex = ECaveMod.loc("block/" + name);
        return (BlockBuilder)REGISTRATE.block(name, Material.f_76300_, props -> new CustomMushroomBlock(mushroom, (BlockBehaviour.Properties)props)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cross(ctx.getName(), tex))).addLayer(() -> RenderType::m_110463_).properties(props -> props.m_60978_(0.0f).m_60977_().m_60910_().m_60918_(SoundType.f_56740_)).lang(localized).item().properties(p -> p.m_41489_(food)).model((ctx, prov) -> prov.generated((NonNullSupplier<? extends ItemLike>)ctx, tex)).tab(() -> ECaveMod.TAB).build();
    }

    private static BlockBuilder<MossBlock, Registrate> moss(String name, MossType type) {
        ResourceLocation tex = ECaveMod.loc("block/" + name);
        return (BlockBuilder)REGISTRATE.block(name, Material.f_76300_, p -> new MossBlock(type, (BlockBehaviour.Properties)p)).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cross(ctx.getName(), tex))).addLayer(() -> RenderType::m_110463_).properties(props -> props.m_60966_().m_60910_().m_60918_(SoundType.f_56740_)).item().tab(() -> ECaveMod.TAB).model((ctx, prov) -> prov.generated((NonNullSupplier<? extends ItemLike>)ctx, tex)).build();
    }

    private static <T extends Block> BlockBuilder<T, Registrate> vine(String name, NonNullFunction<BlockBehaviour.Properties, T> factory) {
        return REGISTRATE.block(name, Material.f_76300_, factory).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cross(ctx.getName(), ECaveMod.loc("block/" + name)))).loot((t, b) -> t.m_124165_((Block)b, RegistrateBlockLootTables.createShearsDispatchTable((Block)CAVE_VINE_END.get(), ((LootPoolSingletonContainer.Builder)RegistrateBlockLootTables.applyExplosionDecay((ItemLike)b, LootItem.m_79579_((ItemLike)((ItemLike)ModItems.PLANT_FIBER.get())))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))))).addLayer(() -> RenderType::m_110463_);
    }

    private static BlockBuilder<Block, Registrate> dumbBlock(String name) {
        return (BlockBuilder)REGISTRATE.block(name, Material.f_76278_, Block::new).item().tab(() -> ECaveMod.TAB).build();
    }

    private static BlockBuilder<Block, Registrate> stoneBlock(String name) {
        return ModBlocks.dumbBlock(name).tag(BlockTags.f_13061_);
    }

    private static BlockBuilder<StairBlock, Registrate> stairBlock(String name, Supplier<Block> mainBlock) {
        return (BlockBuilder)REGISTRATE.block(name + "_stairs", Material.f_76278_, p -> new StairBlock(() -> ModBlocks.lambda$stairBlock$96((Supplier)mainBlock), p)).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.get(), ECaveMod.loc("block/" + name))).recipe((ctx, prov) -> prov.stairs(DataIngredient.items((ItemLike)((Block)mainBlock.get()), (ItemLike[])new Block[0]), ctx, (String)null, true)).tag(BlockTags.f_13030_).item().tag(ItemTags.f_13138_).tab(() -> ECaveMod.TAB).build();
    }

    private static BlockBuilder<SlabBlock, Registrate> slabBlock(String name, Supplier<Block> mainBlock) {
        return (BlockBuilder)REGISTRATE.block(name + "_slab", Material.f_76278_, SlabBlock::new).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), ECaveMod.loc("block/" + name), ECaveMod.loc("block/" + name))).recipe((ctx, prov) -> prov.slab(DataIngredient.items((ItemLike)((Block)mainBlock.get()), (ItemLike[])new Block[0]), ctx, (String)null, true)).tag(BlockTags.f_13031_).item().tag(ItemTags.f_13139_).tab(() -> ECaveMod.TAB).build();
    }

    private static BlockBuilder<StoneButtonBlock, Registrate> buttonBlock(String name, Supplier<Block> mainBlock) {
        return (BlockBuilder)REGISTRATE.block(name + "_button", Material.f_76278_, StoneButtonBlock::new).blockstate((ctx, prov) -> prov.buttonBlock((ButtonBlock)ctx.get(), ECaveMod.loc("block/" + name))).recipe((ctx, prov) -> prov.singleItem(DataIngredient.items((ItemLike)((Block)mainBlock.get()), (ItemLike[])new Block[0]), ctx, 1, 1)).tag(BlockTags.f_13093_).item().model((ctx, prov) -> prov.buttonInventory(name + "_button", ECaveMod.loc("block/" + name))).tag(ItemTags.f_13171_).tab(() -> ECaveMod.TAB).build();
    }

    private static BlockBuilder<PressurePlateBlock, Registrate> pressurePlateBlock(String name, Supplier<Block> mainBlock) {
        return (BlockBuilder)REGISTRATE.block(name + "_pressure_plate", Material.f_76278_, p -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, p)).blockstate((ctx, prov) -> prov.pressurePlateBlock((PressurePlateBlock)ctx.get(), ECaveMod.loc("block/" + name))).tag(BlockTags.f_13101_).item().tab(() -> ECaveMod.TAB).build();
    }

    private static BlockBuilder<WallBlock, Registrate> wallBlock(String name, Supplier<Block> mainBlock) {
        return (BlockBuilder)REGISTRATE.block(name + "_wall", Material.f_76278_, WallBlock::new).blockstate((ctx, prov) -> prov.wallBlock((WallBlock)ctx.get(), ECaveMod.loc("block/" + name))).recipe((ctx, prov) -> prov.wall(DataIngredient.items((ItemLike)((Block)mainBlock.get()), (ItemLike[])new Block[0]), ctx)).tag(BlockTags.f_13032_).item().model((ctx, prov) -> prov.wallInventory(name + "_wall", ECaveMod.loc("block/" + name))).tag(ItemTags.f_13140_).tab(() -> ECaveMod.TAB).build();
    }

    private static BlockBuilder<RockpileBlock, Registrate> pileBlock(String name, ResourceLocation texture, Supplier<Block> stoneBlock) {
        return ModBlocks.pileBlock(name, texture, stoneBlock, false);
    }

    private static BlockBuilder<RockpileBlock, Registrate> pileBlock(String name, ResourceLocation texture, Supplier<Block> stoneBlock, boolean development) {
        return (BlockBuilder)REGISTRATE.block(name, Material.f_76278_, RockpileBlock::new).properties(props -> props.m_60988_()).blockstate((ctx, prov) -> {
            BlockModelBuilder pebbleModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_pebble", ECaveMod.loc("block/pebble"))).texture("0", texture)).texture("particle", texture);
            BlockModelBuilder smallPileModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_small_pile", ECaveMod.loc("block/small_rockpile"))).texture("0", texture)).texture("particle", texture);
            BlockModelBuilder bigPileModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_big_pile", ECaveMod.loc("block/big_rockpile"))).texture("0", texture)).texture("particle", texture);
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)prov.getVariantBuilder((Block)ctx.get()).partialState().with((Property)RockpileBlock.PEBBLES, (Comparable)Integer.valueOf(1)).modelForState().modelFile((ModelFile)pebbleModel).nextModel().modelFile((ModelFile)pebbleModel).rotationY(90).nextModel().modelFile((ModelFile)pebbleModel).rotationY(180).nextModel().modelFile((ModelFile)pebbleModel).rotationY(270).addModel()).partialState().with((Property)RockpileBlock.PEBBLES, (Comparable)Integer.valueOf(2)).modelForState().modelFile((ModelFile)smallPileModel).nextModel().modelFile((ModelFile)smallPileModel).rotationY(90).nextModel().modelFile((ModelFile)smallPileModel).rotationY(180).nextModel().modelFile((ModelFile)smallPileModel).rotationY(270).addModel()).partialState().with((Property)RockpileBlock.PEBBLES, (Comparable)Integer.valueOf(3)).modelForState().modelFile((ModelFile)bigPileModel).nextModel().modelFile((ModelFile)bigPileModel).rotationY(90).nextModel().modelFile((ModelFile)bigPileModel).rotationY(180).nextModel().modelFile((ModelFile)bigPileModel).rotationY(270).addModel();
        }).loot((t, b) -> t.m_124165_((Block)b, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)b).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)RockpileBlock.PEBBLES, 1)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)b).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)RockpileBlock.PEBBLES, 2)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)))).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)b).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)RockpileBlock.PEBBLES, 3)))).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f))))))).item(PebbleItem::new).model((ctx, prov) -> {
            if (development) {
                prov.withExistingParent(ctx.getName(), new ResourceLocation("item/barrier"));
            } else {
                prov.generated((NonNullSupplier<? extends ItemLike>)ctx, ECaveMod.loc("item/" + name));
            }
        }).tag(ModTags.Items.STONE_PEBBLES).recipe((ctx, prov) -> {
            prov.singleItem(DataIngredient.items(ctx, new NonNullSupplier[0]), stoneBlock, 9, 1);
            prov.stonecutting(DataIngredient.items((ItemLike)((Block)stoneBlock.get()), (ItemLike[])new Block[0]), ctx, 9);
        }).tab(() -> ECaveMod.TAB).build();
    }

    private static BlockBuilder<PotBlock, Registrate> pot(String name, PotType type) {
        return (BlockBuilder)REGISTRATE.block(name, Material.f_76310_, props -> new PotBlock(type, (BlockBehaviour.Properties)props)).blockstate((ctx, prov) -> prov.horizontalBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(type.blockModel))).properties(props -> props.m_60955_()).item().properties(props -> props.m_41497_(Rarity.UNCOMMON)).model((ctx, prov) -> {}).tab(() -> ECaveMod.TAB).build();
    }

    public static void register() {
    }

    private static /* synthetic */ BlockState lambda$stairBlock$96(Supplier mainBlock) {
        return ((Block)mainBlock.get()).m_49966_();
    }
}

