/*
 * Decompiled with CFR 0.152.
 */
package dev.nerdthings.extendedcaves.repack.registrate.util.nullness;

import dev.nerdthings.extendedcaves.repack.registrate.util.nullness.NonnullType;
import dev.nerdthings.extendedcaves.repack.registrate.util.nullness.NullableType;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraftforge.common.util.Lazy;

@FunctionalInterface
public interface NonNullSupplier<@NonnullType T>
extends Supplier<T> {
    @Override
    public T get();

    public static <T> NonNullSupplier<T> of(Supplier<@NullableType T> sup) {
        return NonNullSupplier.of(sup, () -> "Unexpected null value from supplier");
    }

    public static <T> NonNullSupplier<T> of(Supplier<@NullableType T> sup, NonNullSupplier<String> errorMsg) {
        return () -> {
            Object res = sup.get();
            Objects.requireNonNull(res, errorMsg);
            return res;
        };
    }

    default public NonNullSupplier<T> lazy() {
        return NonNullSupplier.lazy(this);
    }

    public static <T> NonNullSupplier<T> lazy(Supplier<@NonnullType T> sup) {
        return () -> Lazy.of(sup).get();
    }
}

