/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.blur;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.shaders.Uniform;
import de.cheaterpaul.blur.BlurConfig;
import de.cheaterpaul.blur.util.ShaderResourcePack;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="reblured")
public class BlurClient {
    private static float prevProgress = -1.0f;
    private static Field _listShaders;
    private static long start;
    private static final ShaderResourcePack dummyPack;
    private static final KeyMapping toggleKey;
    private static final ResourceLocation fade_in_blur;
    public static boolean clicked;

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BlurClient::registerPackRepository);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BlurClient::clientSetup);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        ClientRegistry.registerKeyBinding((KeyMapping)toggleKey);
    }

    @SubscribeEvent
    public static void handleInput(InputEvent.KeyInputEvent event) {
        if (!clicked && toggleKey.m_90832_(event.getKey(), event.getScanCode())) {
            Screen screen;
            clicked = true;
            if (Minecraft.m_91087_().f_91073_ != null && (screen = Minecraft.m_91087_().f_91080_) != null) {
                boolean added;
                String clazz = screen.getClass().getName();
                List s = (List)BlurConfig.CLIENT.guiExclusions.get();
                if (s.contains(clazz)) {
                    s.remove(clazz);
                    added = false;
                } else {
                    s.add(clazz);
                    added = true;
                }
                BlurConfig.CLIENT.guiExclusions.set((Object)s);
                BlurClient.onConfigChange(added);
            }
        } else {
            clicked = false;
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        float progress;
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91080_ != null && Minecraft.m_91087_().f_91063_.m_109149_() != null && (progress = BlurClient.getProgress()) != prevProgress) {
            prevProgress = progress;
            BlurClient.updateUniform("Progress", progress);
        }
    }

    public static void updateUniform(String name, float value) {
        if (_listShaders == null) {
            return;
        }
        PostChain sg = Minecraft.m_91087_().f_91063_.m_109149_();
        if (sg != null) {
            try {
                List shaders = (List)_listShaders.get(sg);
                for (PostPass s : shaders) {
                    Uniform su = s.m_110074_().m_108952_(name);
                    if (su == null) continue;
                    su.m_5985_(value);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @SubscribeEvent
    public static void onGuiChange(ScreenOpenEvent event) throws SecurityException {
        BlurClient.updateShader(event.getScreen() == null || BlurConfig.guiExlusions.contains(event.getScreen().getClass().getName()));
    }

    public static void onConfigChange(boolean excluded) {
        BlurClient.updateShader(excluded);
    }

    public static void updateShader(boolean excluded) {
        if (_listShaders == null) {
            _listShaders = ObfuscationReflectionHelper.findField(PostChain.class, (String)"f_110009_");
        }
        if (Minecraft.m_91087_().f_91073_ != null) {
            GameRenderer er = Minecraft.m_91087_().f_91063_;
            PostChain postChain = er.m_109149_();
            if (!excluded) {
                if (postChain == null || fade_in_blur.toString().equals(postChain.m_110022_())) {
                    er.m_109128_(fade_in_blur);
                    BlurClient.updateUniform("Radius", ((Integer)BlurConfig.CLIENT.radius.get()).intValue());
                    if (start == -1L) {
                        start = System.currentTimeMillis();
                    } else {
                        BlurClient.updateUniform("Progress", BlurClient.getProgress());
                    }
                }
            } else if (postChain != null && fade_in_blur.toString().equals(postChain.m_110022_())) {
                er.m_109086_();
                start = -1L;
            }
        } else {
            start = -1L;
        }
    }

    @SubscribeEvent
    public static void onResourceListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)dummyPack);
    }

    private static float getProgress() {
        return Math.min((float)(System.currentTimeMillis() - start) / (float)((Integer)BlurConfig.CLIENT.fadeTime.get()).intValue(), 1.0f);
    }

    public static void registerPackRepository(AddPackFindersEvent event) {
        event.addRepositorySource((infoConsumer, infoFactory) -> infoConsumer.accept(new Pack("reblured", true, () -> dummyPack, (Component)new TextComponent(dummyPack.m_8017_()), (Component)new TextComponent("Default shaders for Blur"), PackCompatibility.COMPATIBLE, Pack.Position.BOTTOM, true, PackSource.f_10527_, false)));
    }

    public static int getBackgroundColor(boolean second) {
        int color = second ? BlurConfig.colorSecond : BlurConfig.colorFirst;
        int a = color >> 24;
        int r = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int g = color & 0xFF;
        float prog = BlurClient.getProgress();
        a = (int)((float)a * prog);
        r = (int)((float)r * prog);
        g = (int)((float)g * prog);
        b = (int)((float)b * prog);
        return a << 24 | r << 16 | b << 8 | g;
    }

    static {
        dummyPack = new ShaderResourcePack();
        toggleKey = new KeyMapping("keys.reblured.toggle", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 299, "keys.reblured.category");
        fade_in_blur = new ResourceLocation("shaders/post/fade_in_blur.json");
    }
}

