/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stal111.valhelsia_structures.core.init.ModRecipes;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AxeCraftingRecipeBuilder {
    private final Ingredient input;
    private final Item output;
    private final int count;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public AxeCraftingRecipeBuilder(Ingredient input, Item output, int count) {
        this.input = input;
        this.output = output;
        this.count = count;
    }

    public AxeCraftingRecipeBuilder unlocks(String name, CriterionTriggerInstance triggerInstance) {
        this.advancement.m_138386_(name, triggerInstance);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output));
    }

    public void save(Consumer<FinishedRecipe> consumer, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Axe Crafting Recipe " + save + " should remove its 'save' argument");
        }
        this.save(consumer, new ResourceLocation(save));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, this.output, this.count, this.input, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/" + this.output.m_41471_().m_40783_() + "/" + id.m_135815_())));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pId);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item output;
        private final int count;
        private final Ingredient input;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Item output, int count, Ingredient input, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.output = output;
            this.count = count;
            this.input = input;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.add("input", this.input.m_43942_());
            JsonObject output = new JsonObject();
            output.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.output)).toString());
            if (this.count > 1) {
                output.addProperty("count", (Number)this.count);
            }
            json.add("output", (JsonElement)output);
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.AXE_CRAFTING_SERIALIZER.get();
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

